//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "phase.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFphase *Fphase;
#include <math.h>
#include <stdio.h>
//#include <dstring.h>

//---------------------------------------------------------------------------
__fastcall TFphase::TFphase(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFphase::BexitClick(TObject *Sender)
{
Close();        
}
//---------------------------------------------------------------------------
void __fastcall TFphase::BcalcClick(TObject *Sender)
{
  double t, r, p1, p2, A1, A2, G1, G2, U1, U2;

  t = ET->Text.ToDouble();
  r = ERho->Text.ToDouble();

	p1 = Ree(t, r);
	A1 = ReeA(t,r);
	U1 = ReeU(t,r);
	G1 = A1*t + p1/r -t;
	p2 = Nicolas(t, r);
	A2 = NicolasA(t,r);
	U2 = NicolasU(t,r);
	G2 = A2*t + p2/r -t;

  EP1->Text = (AnsiString)p1;
  EP2->Text = (AnsiString)p2;
  EP_KT1->Text = (AnsiString)(p1/r/t);
  EP_KT2->Text = (AnsiString)(p2/r/t);

  EA1->Text = (AnsiString)(A1*t);
  EA2->Text = (AnsiString)(A2*t);
  EA_KT1->Text = (AnsiString)A1;
  EA_KT2->Text = (AnsiString)A2;

  EG1->Text = (AnsiString)G1;
  EG2->Text = (AnsiString)G2;
  EG_KT1->Text = (AnsiString)(G1/t);
  EG_KT2->Text = (AnsiString)(G2/t);

  EU1->Text = (AnsiString)(U1*t);
  EU2->Text = (AnsiString)(U2*t);
  EU_KT1->Text = (AnsiString)U1;
  EU_KT2->Text = (AnsiString)U2;

  EE1->Text = (AnsiString)(U1*t+1.5*t);
  EE2->Text = (AnsiString)(U2*t+1.5*t);
  EE_KT1->Text = (AnsiString)(U1+1.5);
  EE_KT2->Text = (AnsiString)(U2+1.5);

  ES_KT1->Text = (AnsiString)(U1 + p1/r/t -1 - G1/t);
  ES_KT2->Text = (AnsiString)(U2 + p2/r/t -1 - G2/t);


}

/*
double erf(double x)
{
	double t, z, ans;
	double erfc;
	z = fabs(x);
	t = 1.0/(1.0+0.5*z);
	ans = t*exp(-z*z -1.26551223+t*(1.00002368+t*(0.37409196+t*(0.09678418+
		  t*(-0.18628806+t*(0.27886807+t*(-1.13520398+t*(1.48851587+
		  t*(-0.82215223+t*0.17087277)))))))));
	erfc =  x>=0.0 ? ans: 2.0-ans;
	return 1.0-erfc;
}
*/

double TFphase::Ree(double t, double r)  // returns P*  for T* and rho*
{
  double p,prep;
  double B[5], B10;
  double C[6];
  double D[6];
  double x;
  double temp1, temp2, temp3;
  int i;
  
  B[1] = 3.629;
  B[2] = 7.2641;
  B[3] = 10.4924;
  B[4] = 11.459;
  B10 = 2.17619;
  C[1] = 5.3692;
  C[2] = 6.5797;
  C[3] = 6.1745;
  C[4] = -4.2685;
  C[5] = 1.6841;
  D[1] = -3.4921;
  D[2] = 18.6980;
  D[3] = -35.5049;
  D[4] = 31.8151;
  D[5] = -11.1953;
  
  x = r/pow(t,0.25);
  temp1 = temp2 = temp3 = 0.0;
  for(i=1; i<=4; i++) temp1 = temp1+B[i]*pow(x,i);
  
  prep = 1.0 + temp1 + B10*pow(x,10);
  for(i=1; i<=5; i++) {
  	temp2 = temp2+(double)i*C[i]*pow(x,i);
  	temp3 = temp3 + D[i]*pow(x,i);
  }
  p = prep - sqrt(1.0/t)*temp2
           + (1.0/t)*temp3;
  return p*r*t;
}

double TFphase::ReeA(double t, double r)  // returns Ae/(kT)  for T* and rho*
{
  double A;
  double p,prep;
  double B[5], B10;
  double C[6];
  double D[6];
  double x;
  double temp1, temp2, temp3;
  int i;

  B[1] = 3.629;
  B[2] = 7.2641;
  B[3] = 10.4924;
  B[4] = 11.459;
  B10 = 2.17619;
  C[1] = 5.3692;
  C[2] = 6.5797;
  C[3] = 6.1745;
  C[4] = -4.2685;
  C[5] = 1.6841;
  D[1] = -3.4921;
  D[2] = 18.6980;
  D[3] = -35.5049;
  D[4] = 31.8151;
  D[5] = -11.1953;
  
  x = r/pow(t,0.25);
  temp1 = temp2 = temp3 = 0.0;
  for(i=1; i<=4; i++) temp1 = temp1+1.0/(double)i*B[i]*pow(x,i);
  temp1 = temp1 + 1.0/10.0*B10*pow(x,10);

  for(i=1; i<=5; i++) {
  	temp2 = temp2 + C[i]*pow(x,i);
  	temp3 = temp3 + 1.0/(double)i*D[i]*pow(x,i);
  }
  A = temp1 - sqrt(1.0/t)*temp2 + (1.0/t)*temp3;
  return A;
}

double TFphase::ReeU(double t, double r)  // returns Ue /(kT)
{
  double U, Ub;
  double p1;
  double B[5], B10;
  double C[6];
  double D[6];
  double x;
  double temp1, temp2, temp3, temp4, temp5;
  int i;
  
  B[1] = 3.629;
  B[2] = 7.2641;
  B[3] = 10.4924;
  B[4] = 11.459;
  B10 = 2.17619;
  C[1] = 5.3692;
  C[2] = 6.5797;
  C[3] = 6.1745;
  C[4] = -4.2685;
  C[5] = 1.6841;
  D[1] = -3.4921;
  D[2] = 18.6980;
  D[3] = -35.5049;
  D[4] = 31.8151;
  D[5] = -11.1953;
  
  x = r/pow(t,0.25);
  temp1 = temp2 = temp3 = temp4 = temp5 = 0.0;
  for(i=1; i<=4; i++) temp1 = temp1+B[i]*pow(x,i);
  temp1 = temp1 + B10*pow(x,10);
  for(i=1; i<=5; i++) {
  	temp2 = temp2+(double)i*C[i]*pow(x,i);
  	temp3 = temp3 + D[i]*pow(x,i);
  }
  p1 = temp1 - sqrt(1.0/t)*temp2
           + (1.0/t)*temp3;

  for(i=1; i<=5; i++) {
  	temp4 = temp4 + C[i]*pow(x,i);
  	temp5 = temp5 + 1.0/(double)i*D[i]*pow(x,i);
  }

  Ub = 0.25*p1 - 0.5*sqrt(1.0/t)*temp4 + (1.0/t)*temp5;

  return Ub;
}

double TFphase::Nicolas(double t, double r){  //returns p*
  double p,v,pe;

  double c,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,
         x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,
         x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32;
  
  c=3.0;
  x1 =-0.44480725e-1;
  x2 = 0.72738221e1;
  x3 =-0.14343368e2;
  x4 = 0.38397096e1;
  x5 =-0.20057745e1;
  x6 = 0.19084472e1;
  x7 =-0.57441787e1;
  x8 = 0.25110073e2;
  x9 =-0.45232787e4;
  x10= 0.89327162e-2;
  x11= 0.98163358e1;
  x12=-0.61434572e2;
  x13= 0.14161454e2;
  x14= 0.43353841e2;
  x15= 0.11078327e4;
  x16=-0.35429519e2;
  x17= 0.10591298e2;
  x18= 0.49770046e3;
  x19=-0.35338542e3;
  x20= 0.45036093e4;
  x21= 0.77805296e1;
  x22= 0.13567114e5;
  x23=-0.85818023e1;
  x24= 0.16646578e5;
  x25=-0.14092234e2;
  x26= 0.19386911e5;
  x27= 0.38585868e2;
  x28= 0.33800371e4;
  x29=-0.18567754e3;
  x30= 0.84874693e4;
  x31= 0.97508689e2;
  x32=-0.14483060e2;
  
    p=r*t+pow(r,2)*(x1*t+x2*sqrt(t)+x3+x4/t+x5/t/t)
       +pow(r,3)*(x6*t+x7+x8/t+x9/t/t)
       +pow(r,4)*(x10*t+x11+x12/t)
       +pow(r,5)*x13
       +pow(r,6)*(x14/t+x15/t/t)
       +pow(r,7)*(x16/t)
       +pow(r,8)*(x17/t+x18/t/t)
       +pow(r,9)*(x19/t/t)
       +pow(r,3)*(x20/t/t+x21/t/t/t)*exp(-c*r*r)
       +pow(r,5)*(x22/t/t+x23/t/t/t/t)*exp(-c*r*r)
       +pow(r,7)*(x24/t/t+x25/t/t/t)*exp(-c*r*r)
       +pow(r,9)*(x26/t/t+x27/t/t/t/t)*exp(-c*r*r)
       +pow(r,11)*(x28/t/t+x29/t/t/t)*exp(-c*r*r)
       +pow(r,13)*(x30/t/t+x31/t/t/t+x32/t/t/t/t)*exp(-c*r*r);

	return p;
}

double TFphase::NicolasA(double t, double r){  //returns Ae/(kT)
  double p,v,pe, A;
//  double pi = 3.1415926535897932384626433832795;
  double E = 2.7182818284590452353602874713527;
  double integral1, integral2, integral3, integral4,integral5,integral6;

  double c,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,
         x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,
         x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32;
  c=3.0;
  x1 =-0.44480725e-1;
  x2 = 0.72738221e1;
  x3 =-0.14343368e2;
  x4 = 0.38397096e1;
  x5 =-0.20057745e1;
  x6 = 0.19084472e1;
  x7 =-0.57441787e1;
  x8 = 0.25110073e2;
  x9 =-0.45232787e4;
  x10= 0.89327162e-2;
  x11= 0.98163358e1;
  x12=-0.61434572e2;
  x13= 0.14161454e2;
  x14= 0.43353841e2;
  x15= 0.11078327e4;
  x16=-0.35429519e2;
  x17= 0.10591298e2;
  x18= 0.49770046e3;
  x19=-0.35338542e3;
  x20= 0.45036093e4;
  x21= 0.77805296e1;
  x22= 0.13567114e5;
  x23=-0.85818023e1;
  x24= 0.16646578e5;
  x25=-0.14092234e2;
  x26= 0.19386911e5;
  x27= 0.38585868e2;
  x28= 0.33800371e4;
  x29=-0.18567754e3;
  x30= 0.84874693e4;
  x31= 0.97508689e2;
  x32=-0.14483060e2;

  integral1 = 1/(2*c) - 1/(2*c*pow(E,c*pow(r,2)));
  
  integral2 = 1/(2*pow(c,2)) + (-1/(2*pow(c,2)) - pow(r,2)/(2*c))/pow(E,c*pow(r,2));
  
  integral3 = pow(c,-3) + (-pow(c,-3) - pow(r,2)/pow(c,2) - pow(r,4)/(2*c))/
    pow(E,c*pow(r,2));
  
  integral4 = 3/pow(c,4) + (-3/pow(c,4) - 3*pow(r,2)/pow(c,3) - 
      3*pow(r,4)/(2*pow(c,2)) - pow(r,6)/(2*c))/pow(E,c*pow(r,2));
     
  integral5 = 12/pow(c,5) + (-12/pow(c,5) - 12*pow(r,2)/pow(c,4) - 6*pow(r,4)/pow(c,3) - 
      2*pow(r,6)/pow(c,2) - pow(r,8)/(2*c))/pow(E,c*pow(r,2));

  integral6 = 60/pow(c,6) + (-60/pow(c,6) - 60*pow(r,2)/pow(c,5) - 
      30*pow(r,4)/pow(c,4) - 10*pow(r,6)/pow(c,3) - 
      5*pow(r,8)/(2*pow(c,2)) - pow(r,10)/(2*c))/pow(E,c*pow(r,2));
   
   A =  pow(r,1)*(x1*t+x2*sqrt(t)+x3+x4/t+x5/t/t)  /t/1.0
       +pow(r,2)*(x6*t+x7+x8/t+x9/t/t)  /t/2.0
       +pow(r,3)*(x10*t+x11+x12/t)  /t/3.0
       +pow(r,4)*x13  /t/4.0
       +pow(r,5)*(x14/t+x15/t/t)  /t/5.0
       +pow(r,6)*(x16/t)  /t/6.0
       +pow(r,7)*(x17/t+x18/t/t)  /t/7.0
       +pow(r,8)*(x19/t/t)  /t/8.0
       +(x20/t/t+x21/t/t/t)  			/t*integral1
       +(x22/t/t+x23/t/t/t/t)  			/t*integral2
       +(x24/t/t+x25/t/t/t)  			/t*integral3
       +(x26/t/t+x27/t/t/t/t)  			/t*integral4
       +(x28/t/t+x29/t/t/t)  			/t*integral5
       +(x30/t/t+x31/t/t/t+x32/t/t/t/t)	/t*integral6;

	return A;
}

double TFphase::NicolasU(double t, double r){  //returns Ue/(kT)
  double p,v,pe, A,U;
//  double pi = 3.1415926535897932384626433832795;
  double E = 2.7182818284590452353602874713527;
  double integral1, integral2, integral3, integral4,integral5,integral6;
  double t1, t2, t3, t4, t5, t6, t7, t8;
  double tb1, tb2, tb3, tb4, tb5, tb6;

  double c,x1,x2,x3,x4,x5,x6,x7,x8,x9,x10,
         x11,x12,x13,x14,x15,x16,x17,x18,x19,x20,
         x21,x22,x23,x24,x25,x26,x27,x28,x29,x30,x31,x32;
  c=3.0;
  x1 =-0.44480725e-1;
  x2 = 0.72738221e1;
  x3 =-0.14343368e2;
  x4 = 0.38397096e1;
  x5 =-0.20057745e1;
  x6 = 0.19084472e1;
  x7 =-0.57441787e1;
  x8 = 0.25110073e2;
  x9 =-0.45232787e4;
  x10= 0.89327162e-2;
  x11= 0.98163358e1;
  x12=-0.61434572e2;
  x13= 0.14161454e2;
  x14= 0.43353841e2;
  x15= 0.11078327e4;
  x16=-0.35429519e2;
  x17= 0.10591298e2;
  x18= 0.49770046e3;
  x19=-0.35338542e3;
  x20= 0.45036093e4;
  x21= 0.77805296e1;
  x22= 0.13567114e5;
  x23=-0.85818023e1;
  x24= 0.16646578e5;
  x25=-0.14092234e2;
  x26= 0.19386911e5;
  x27= 0.38585868e2;
  x28= 0.33800371e4;
  x29=-0.18567754e3;
  x30= 0.84874693e4;
  x31= 0.97508689e2;
  x32=-0.14483060e2;

  integral1 = 1/(2*c) - 1/(2*c*pow(E,c*pow(r,2)));
  
  integral2 = 1/(2*pow(c,2)) + (-1/(2*pow(c,2)) - pow(r,2)/(2*c))/pow(E,c*pow(r,2));
  
  integral3 = pow(c,-3) + (-pow(c,-3) - pow(r,2)/pow(c,2) - pow(r,4)/(2*c))/
    pow(E,c*pow(r,2));
  
  integral4 = 3/pow(c,4) + (-3/pow(c,4) - 3*pow(r,2)/pow(c,3) - 
      3*pow(r,4)/(2*pow(c,2)) - pow(r,6)/(2*c))/pow(E,c*pow(r,2));
     
  integral5 = 12/pow(c,5) + (-12/pow(c,5) - 12*pow(r,2)/pow(c,4) - 6*pow(r,4)/pow(c,3) - 
      2*pow(r,6)/pow(c,2) - pow(r,8)/(2*c))/pow(E,c*pow(r,2));

  integral6 = 60/pow(c,6) + (-60/pow(c,6) - 60*pow(r,2)/pow(c,5) -
      30*pow(r,4)/pow(c,4) - 10*pow(r,6)/pow(c,3) - 
      5*pow(r,8)/(2*pow(c,2)) - pow(r,10)/(2*c))/pow(E,c*pow(r,2));

//   (x1*t+x2*sqrt(t)+x3+x4/t+x5/t/t)  /t
	t1 = t*((x1 + 0.5*x2/pow(t,0.5) - x4/pow(t,2) - 2*x5/pow(t,3))/t - 
     (t*x1 + pow(t,0.5)*x2 + x3 + x4/t + x5/pow(t,2))/pow(t,2));

//   (x6*t+x7+x8/t+x9/t/t)  /t
	t2 = t*((x6 - x8/pow(t,2) - 2*x9/pow(t,3))/t - 
     (t*x6 + x7 + x8/t + x9/pow(t,2))/pow(t,2));

//   (x10*t+x11+x12/t)  /t
	t3 = t*((x10 - x12/pow(t,2))/t - (t*x10 + x11 + x12/t)/pow(t,2));

//   x13  /t
	t4 = -(x13/t);

//   (x14/t+x15/t/t)  /t
	t5 = t*((-(x14/pow(t,2)) - 2*x15/pow(t,3))/t - (x14/t + x15/pow(t,2))/pow(t,2));

//   (x16/t)  /t
	t6 = -2*x16/pow(t,2);

//   (x17/t+x18/t/t)  /t
	t7 = t*((-(x17/pow(t,2)) - 2*x18/pow(t,3))/t - (x17/t + x18/pow(t,2))/pow(t,2));

//   (x19/t/t)  /t
	t8 = -3*x19/pow(t,3);
	
//   (x20/t/t+x21/t/t/t)/t
	tb1 = t*((-2*x20/pow(t,3) - 3*x21/pow(t,4))/t - 
     (x20/pow(t,2) + x21/pow(t,3))/pow(t,2));

//   (x22/t/t+x23/t/t/t/t)/t
	tb2 = t*((-2*x22/pow(t,3) - 4*x23/pow(t,5))/t - 
     (x22/pow(t,2) + x23/pow(t,4))/pow(t,2));

//   (x24/t/t+x25/t/t/t)/t
	tb3 = t*((-2*x24/pow(t,3) - 3*x25/pow(t,4))/t - 
     (x24/pow(t,2) + x25/pow(t,3))/pow(t,2));

//   (x26/t/t+x27/t/t/t/t)/t
	tb4 = t*((-2*x26/pow(t,3) - 4*x27/pow(t,5))/t - 
     (x26/pow(t,2) + x27/pow(t,4))/pow(t,2));

//   (x28/t/t+x29/t/t/t)/t
	tb5 = t*((-2*x28/pow(t,3) - 3*x29/pow(t,4))/t - 
     (x28/pow(t,2) + x29/pow(t,3))/pow(t,2));

//   ((x30/t/t+x31/t/t/t+x32/t/t/t/t)/t
	tb6 = t*((-2*x30/pow(t,3) - 3*x31/pow(t,4) - 4*x32/pow(t,5))/t - 
     (x30/pow(t,2) + x31/pow(t,3) + x32/pow(t,4))/pow(t,2));
     
   U =  pow(r,1)/1.0*t1
       +pow(r,2)/2.0*t2
       +pow(r,3)/3.0*t3
       +pow(r,4)/4.0*t4
       +pow(r,5)/5.0*t5
       +pow(r,6)/6.0*t6
       +pow(r,7)/7.0*t7
       +pow(r,8)/8.0*t8
       +tb1*integral1
       +tb2*integral2
       +tb3*integral3
       +tb4*integral4
       +tb5*integral5
       +tb6*integral6;
    U = -U;
	return U;
}


//---------------------------------------------------------------------------
void __fastcall TFphase::BIsoTClick(TObject *Sender)
{
   AnsiString Str;
   FILE *fp;
   int i;
   double t, r, p2, p1;
   Str="IsoT"+ET->Text+".dat";
   fp=fopen(Str.c_str(),"w");

  t = ET->Text.ToDouble();
   fprintf(fp, "# rho*  \tt*  \tp*(Ree)  \tp*(Nic)\n");

  for(i=1; i<100; i++){
       r = 0.01*(double)i;      // 0 to 1.0
			p1 = Ree(t, r);
     	p2 = Nicolas(t, r);
       fprintf(fp, "%lg \t%lg \t%lg \t%lg\n", r, t, p1, p2);
   }
   fclose(fp);

}
//---------------------------------------------------------------------------

void __fastcall TFphase::BIsoPClick(TObject *Sender)
{
   AnsiString Str;
   FILE *fp;
   int i, j;
   double t, r, p2, p1;
   double press;
   double diff, diffold;
// Nicolas
   Str="IsoPNic"+Epress->Text+".dat";
   fp=fopen(Str.c_str(),"w");

   press = Epress->Text.ToDouble();
   fprintf(fp, "# rho*  \tT*  \tp*(Nic)\n");

   diffold = 1.0;
  for(i=1; i<100; i++){
       r = 0.01*(double)i;      // 0 to 1.2
       for(t = 6.0; t > 0.5; t=t-0.001){
//          t = 0.0005*(double)j;
           p2 = Nicolas(t, r);
          diff = press - p2;
          if(t!=6.0 && diff*diffold <0.0) break;
          diffold = diff;
       }
       if(fabs(diff) < 0.01)
       fprintf(fp, "%lg \t%lg \t%lg\n", r, t, p2);
  }
   fclose(fp);
/// Ree
   Str="IsoPRee"+Epress->Text+".dat";
   fp=fopen(Str.c_str(),"w");

   press = Epress->Text.ToDouble();
   fprintf(fp, "# rho*  \tT*  \tp*(Ree)\n");

   diffold = 1.0;
  for(i=1; i<100; i++){
       r = 0.01*(double)i;      // 0 to 1.2
       for(t = 6.0; t > 0.5; t=t-0.001){
//          t = 0.0005*(double)j;
           p1 = Ree(t, r);
          diff = press - p1;
          if(t!=6.0 && diff*diffold <0.0) break;
          diffold = diff;
       }
       if(fabs(diff) < 0.01)
       fprintf(fp, "%lg \t%lg \t%lg\n", r, t, p1);
  }
   fclose(fp);

}
//---------------------------------------------------------------------------

void __fastcall TFphase::Button1Click(TObject *Sender)
{
   AnsiString Str;
   FILE *fp;
   int i;
   double r, t, p1, p2, U1, U2;
   Str="IsoRho"+ERho->Text+".dat";
   fp=fopen(Str.c_str(),"w");

  r = ERho->Text.ToDouble();


   fprintf(fp, "# rho   T   p(Ree)    p(Nico)   E(Ree)    E(Nico)\n");

  for(i=1; i<100; i++){
       t = 0.02*(double)i;      // 0.0 to 2.0
        p1 = Ree(t, r);
   	p2 = Nicolas(t, r);
       	U1 = ReeU(t,r);
	U2 = NicolasU(t,r);

         fprintf(fp, "%lg %lg %lg %lg %lg %lg\n", r, t, p1, p2, U1*t+1.5*t, U2*t+1.5*t);
   }
   fclose(fp);


}
//---------------------------------------------------------------------------

