c-----------------------------------------------------------
c     Simplest MD program by Shigeo Maruyama 2000-8-7
c-----------------------------------------------------------
      program simple
      parameter(nunit=4, nmol=64)
      implicit double precision(a-h,o-z)
      dimension x(nmol,3),v(nmol,3),fm(nmol,3),dfm(nmol,nmol,3)
c-------------------------------------------------
c     constants
c-------------------------------------------------
      pi  = 4.0d0*atan(1.0d0)
      bk  = 1.381D-23
      an  = 6.022D23
      vl = 20D-10
      vli = 1.0D0/vl
      wm  = 40.0D-3/an
      sig = 3.40D-10
      eps = 1.67D-21
      tini = 100
c
      time = 0.0D0
      dt = 5.0D-15
      nrep = 2000
      nrdm = 10
c-------------------------------------------------
      open(13,file='pos.dat')
      open(15,file='ene.dat')

      do 10 i=1,nunit
        do 10 j=1,nunit
          do 10 k = 1,nunit
             x(i+(j-1)*nunit+(k-1)*nunit*nunit,1)=i*sig
             x(i+(j-1)*nunit+(k-1)*nunit*nunit,2)=j*sig
             x(i+(j-1)*nunit+(k-1)*nunit*nunit,3)=k*sig
  10  continue

      do 20 i=1,nmol
        coef=sqrt((3.0D0*bk*tini)/wm)
        a=ranf(nrdm)*pi*2.0D0
        b=(ranf(nrdm)-0.5D0)*pi
        v(i,1)=coef*cos(b)*sin(a)
        v(i,2)=coef*cos(b)*cos(a)
        v(i,3)=coef*sin(b)
  20  continue

      write(13,*) 1,nmol,nrep/10
      write(13,'(3F7.1)') vl*1.0D10,vl*1.0D10,vl*1.0D10
      write(13,'(3F7.2)') time, dt*1.0D12
      do 30 i=1,nmol
          write(13,'(3F7.1)') (x(i,j)*1.0D10,j=1,3)
  30  continue
c-------------------------------------------------
c     Main routine
c-------------------------------------------------
      write(*,*) 'Main calculation started'
      do 500 irep=1,nrep
        time=time+dt
        ep=0.0d0
        ek=0.0d0

        do 510 i=1,nmol
          fm(i,1)=0.0d0
          fm(i,2)=0.0d0
          fm(i,3)=0.0d0
  510   continue

        do 520 i=1,nmol
          do 520 j=1,nmol
            dfm(i,j,1)=0.0d0
            dfm(i,j,2)=0.0d0
            dfm(i,j,3)=0.0d0
  520   continue
c--------------------------------------------
c     L-J potential 
c--------------------------------------------
        do 530 i=1,nmol-1
          do 530 j=i+1,nmol
            r1=x(i,1)-x(j,1)
            r1=r1-anint(r1*vli)*vl
            r2=x(i,2)-x(j,2)
            r2=r2-anint(r2*vli)*vl
            r3=x(i,3)-x(j,3)
            r3=r3-anint(r3*vli)*vl
            rabs=sqrt(r1*r1+r2*r2+r3*r3)
            rabi=1.0d0/rabs
            sbr6=(sig*rabi)**6
            sl=dsign(0.5D0,vl*0.5d0-rabs)+0.5d0
            dlj=4.0d0*eps*(sbr6-1.0d0)*sbr6*sl
            dflj=24.0d0*eps*(2.0d0*sbr6-1.0d0)*sbr6*rabi*sl
            ep=ep+dlj
            dfm(i,j,1)= dflj*r1*rabi
            dfm(j,i,1)=-dflj*r1*rabi
            dfm(i,j,2)= dflj*r2*rabi
            dfm(j,i,2)=-dflj*r2*rabi
            dfm(i,j,3)= dflj*r3*rabi
            dfm(j,i,3)=-dflj*r3*rabi
c-------------------------------------------------
  530   continue
c-------------------------------------------------
c     sum of forces
c-------------------------------------------------
        do 540 i=1,nmol
          do 540 j=1,nmol
            fm(j,1)=fm(j,1)+dfm(j,i,1)
            fm(j,2)=fm(j,2)+dfm(j,i,2)
            fm(j,3)=fm(j,3)+dfm(j,i,3)
  540   continue
c-------------------------------------------------
c     modification of velocity
c-------------------------------------------------
        do 550 i=1,nmol
          v(i,1)=v(i,1)+fm(i,1)*dt/wm
          v(i,2)=v(i,2)+fm(i,2)*dt/wm
          v(i,3)=v(i,3)+fm(i,3)*dt/wm
          ek=ek+v(i,1)*v(i,1)+v(i,2)*v(i,2)+v(i,3)*v(i,3)
  550   continue
c---------------------------------------------------
c     modification of position
c---------------------------------------------------
        do 560 i=1,nmol
          x(i,1)=x(i,1)+v(i,1)*dt
          x(i,1)=x(i,1)-anint(x(i,1)*vli-0.5d0)*vl
          x(i,2)=x(i,2)+v(i,2)*dt
          x(i,2)=x(i,2)-anint(x(i,2)*vli-0.5d0)*vl
          x(i,3)=x(i,3)+v(i,3)*dt
          x(i,3)=x(i,3)-anint(x(i,3)*vli-0.5d0)*vl
  560   continue
c
        if (mod(irep,10) .eq. 0) then
          do 570 i=1,nmol
            write(13,'(3F7.1)') (x(i,j)*1.0D10,j=1,3)
  570     continue
          write(15,*)time*1.0D12,ep,0.5d0*wm*ek
        end if

        if (mod(irep,100) .eq. 0) then
          write(*,*) 'step:', irep
        endif
  500 continue
      write(*,*) '-- program finished normally --'
      close(13)
      close(15)
c
      stop
      end
c----------------------------------------------------------
c      random number
c----------------------------------------------------------
      function ranf(nrdm)
      implicit double precision(a-h,o-z)
      jl=mod(nrdm,4096)
      jh=(nrdm-jl)/4096
      jl=jl*1899
      jll=mod(jl,4096)
      jlh=(jl-jll)/4096
      jh=mod(jh*1899+jlh,2048)
      nrdm=jh*4096+jll
      ranf=nrdm/8388608.
      return
      end
