#define nmolmax 200
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <conio.h>

double x[nmolmax+1], y[nmolmax+1], z[nmolmax+1];
double vx[nmolmax+1], vy[nmolmax+1], vz[nmolmax+1];
double fmx[nmolmax+1], fmy[nmolmax+1], fmz[nmolmax+1];
double dfmx[nmolmax+1][nmolmax+1], dfmy[nmolmax+1][nmolmax+1], 
		dfmz[nmolmax+1][nmolmax+1];
double pi, bk, an, vl,vli, wm, sig, eps, ep, ek, rc;
double tini, stime, dt;
int nrep, nwrite, nenewrite, ntc;
int nmol;
int nxyuni, nzuni, nrandam;
double dens, tini,temar;

void Consts(void);
void Init(void);
void Step(void);
double anint(double a);
double dsign(double a, double b);
void Tcontrol(void);

void main(void)
{
	FILE *fpos, *fene;
	int i, irep;
	fpos = fopen("pos.dat","w");
	fene = fopen("ene.dat", "w");

	Consts();
	Init();

// output of initial condition
	fprintf(fpos,"1  %d  %d\n", nmol,nrep/nwrite);
	fprintf(fpos,"%lf  %lf  %lf\n", vl*1.0e10,vl*1.0e10,vl*1.0e10);
	fprintf(fpos,"%lf  %lf\n", stime, dt*1.0e12*nwrite);
	for(i=1; i<=nmol; i++){
		fprintf(fpos, "%lf %lf %lf\n",
			x[i]*1.0e10,y[i]*1.0e10, z[i]*1.0e10);
	}

// starting the main loop
	stime = 0.0;
	for(irep=1; irep<=nrep; irep++){
		stime=stime+dt;
		Step();
		if(irep <= ntc) Tcontrol();
		if (irep % nwrite == 0){
			for(i=1; i<=nmol; i++){
				fprintf(fpos, "%lf  %lf  %lf\n",
					x[i]*1.0e10,y[i]*1.0e10,z[i]*1.0e10);
			}
		}
		if(irep % nenewrite == 0){
			fprintf(fene, "%lg \t%lg \t%lg \t%lg \n", stime, ep, ek, temar);
		}
		if (irep % 100 == 0){
			printf("%d\n", irep);
		}
	}

	fclose(fpos);
	fclose(fene);
}

void Consts()
{
	int nrandom;
	FILE *fpcond;
	char aline[128];
	fpcond = fopen("step.dat", "r");
	fgets(aline, 128, fpcond); sscanf(aline, "%d", &nxyuni);
	fgets(aline, 128, fpcond); sscanf(aline, "%d", &nzuni);
	fgets(aline, 128, fpcond); sscanf(aline, "%lf", &dens);
	fgets(aline, 128, fpcond); sscanf(aline, "%lf", &tini);
	fgets(aline, 128, fpcond); sscanf(aline, "%lf", &dt); dt=dt*1.0e-15;
	fgets(aline, 128, fpcond); sscanf(aline, "%d", &nrep);
	fgets(aline, 128, fpcond); sscanf(aline, "%d", &nwrite);
	fgets(aline, 128, fpcond); sscanf(aline, "%d", &nenewrite);
	fgets(aline, 128, fpcond); sscanf(aline, "%d", &ntc);
	fgets(aline, 128, fpcond); sscanf(aline, "%d", &nrandom);
	fgets(aline, 128, fpcond); sscanf(aline, "%lf", &vl); vl = vl * 1.0e-10;
	fgets(aline, 128, fpcond); sscanf(aline, "%lf", &rc);
	fclose(fpcond);

	nmol = 4*nxyuni*nxyuni*nzuni;	//number of molecules
	an  = 6.02217e23;	//cell length
	vli = 1.0/vl;		//just inverse of vl
	wm  = 39.948e-3/an;		//mass of argon
	bk = 1.38066e-23;	//Boltzmann Const
	sig = 3.40e-10;		//sigma
	eps = 1.67e-21;		//epsilon
	pi = 4.0*atan(1.0);
	rc = rc*sig;		//cut off length
	srand(nrandom);    //seeding the randam function rand()
}

void Init()
{
	int im;
	double ul;
	double basex, basey, basez;
	int i, j, k;
	double vtx, vty, vtz;
	double a, b, coef;

//    unit cell length
	ul=pow((wm/dens*4.0),(1.0/3.0));
// ar
	im=0;
	basex=0.5*(vl-nxyuni*ul);
	basey=0.5*(vl-nxyuni*ul);
	basez=0.5*(vl-nzuni*ul);
	for(k=0; k<nzuni; k++){
		for(j=0; j<nxyuni; j++){
			for(i=0; i<nxyuni; i++){
				im=im+1;
				x[im]=ul*(0.25+i)+basex;
				y[im]=ul*(0.25+j)+basey;
				z[im]=ul*(0.25+k)+basez;
				im=im+1;
				x[im]=ul*(0.75+i)+basex;
				y[im]=ul*(0.25+j)+basey;
				z[im]=ul*(0.75+k)+basez;
				im=im+1;
				x[im]=ul*(0.25+i)+basex;
				y[im]=ul*(0.75+j)+basey;
				z[im]=ul*(0.75+k)+basez;
				im=im+1;
				x[im]=ul*(0.75+(i))+basex;
				y[im]=ul*(0.75+(j))+basey;
				z[im]=ul*(0.25+(k))+basez;
			}
		}
	}
// velocity
	for(i=1; i<=nmol; i++){
		coef=sqrt((3.0*bk*tini)/wm);
		a=(double)rand()/(double)RAND_MAX*pi*2.0;
		b=((double)rand()/(double)RAND_MAX-0.5)*pi;
		vx[i]=coef*cos(b)*sin(a);
		vy[i]=coef*cos(b)*cos(a);
		vz[i]=coef*sin(b);
	}
// remove the total translation
	vtx=0.0;
	vty=0.0;
	vtz=0.0;
	for(i=1; i<=nmol; i++){
		vtx=vtx+vx[i];
		vty=vty+vy[i];
		vtz=vtz+vz[i];
	}
	vtx=vtx/(double)nmol;
	vty=vty/(double)nmol;
	vtz=vtz/(double)nmol;

	for(i=1; i<=nmol; i++){
		vx[i]=vx[i]-vtx;
		vy[i]=vy[i]-vty;
		vz[i]=vz[i]-vtz;
	}
}
//---------------------------------------------------------------------------
void Step()
{
	int i, j;
	double r1, r2, r3;
	double rabs, rabi, sbr6, sl,dlj, dflj;
	ep = 0.0;
	ek = 0.0;

	for(i=1; i<=nmol; i++){
		fmx[i]=0.0;
		fmy[i]=0.0;
		fmz[i]=0.0;
	}

	for(i=1; i<=nmol; i++){
		for(j=1; j<=nmol; j++){
			dfmx[i][j]=0.0;
			dfmy[i][j]=0.0;
			dfmz[i][j]=0.0;
		}
	}
//--------------------------------------------
//     L-J potential
//--------------------------------------------
	for(i=1; i<=nmol-1; i++){
		for(j=i+1; j<=nmol; j++){
			r1=x[i]-x[j];
			r1=r1-anint(r1*vli)*vl;
			r2=y[i]-y[j];
			r2=r2-anint(r2*vli)*vl;
			r3=z[i]-z[j];
			r3=r3-anint(r3*vli)*vl;
			rabs=sqrt(r1*r1+r2*r2+r3*r3);
			rabi=1.0/rabs;
			sbr6=pow( sig*rabi, 6);
			sl=dsign(0.5,rc-rabs)+0.5;
			dlj=4.0*eps*(sbr6-1.0)*sbr6*sl;
			dflj=24.0*eps*(2.0*sbr6-1.0)*sbr6*rabi*sl;
			ep=ep+dlj;
			dfmx[i][j]= dflj*r1*rabi;
			dfmx[j][i]=-dflj*r1*rabi;
			dfmy[i][j]= dflj*r2*rabi;
			dfmy[j][i]=-dflj*r2*rabi;
			dfmz[i][j]= dflj*r3*rabi;
			dfmz[j][i]=-dflj*r3*rabi;
		}
	}
//-------------------------------------------------
//     sum of forces
//-------------------------------------------------
	for(i=1; i<=nmol; i++){
		for(j=1; j<=nmol; j++){
			fmx[j]=fmx[j]+dfmx[j][i];
			fmy[j]=fmy[j]+dfmy[j][i];
			fmz[j]=fmz[j]+dfmz[j][i];
		}
	}
//-------------------------------------------------
//     modification of velocity
//-------------------------------------------------
	for(i=1; i<=nmol; i++){
		vx[i]=vx[i]+fmx[i]*dt/wm;
		vy[i]=vy[i]+fmy[i]*dt/wm;
		vz[i]=vz[i]+fmz[i]*dt/wm;
		ek=ek+vx[i]*vx[i]+vy[i]*vy[i]+vz[i]*vz[i];
	}
	ek = 0.5*wm*ek;
	temar = 2.0*ek/( (double)nmol*3.0*bk );
//---------------------------------------------------
//     modification of position
//---------------------------------------------------
	for (i=1; i<=nmol; i++){
		x[i]=x[i]+vx[i]*dt;
		x[i]=x[i]-anint(x[i]*vli-0.5)*vl;
		y[i]=y[i]+vy[i]*dt;
		y[i]=y[i]-anint(y[i]*vli-0.5)*vl;
		z[i]=z[i]+vz[i]*dt;
		z[i]=z[i]-anint(z[i]*vli-0.5)*vl;
	}
}

double anint(double a)
{
	return floor(a+0.5);
}

double dsign(double a, double b)
{
	return (b>0.0) ? a: -a;
//	if(b<0.0) return -fabs(a);
//	else return fabs(a);
}

//Temperature Control
void Tcontrol(void)
{
	double st;
	int i;
	st=sqrt(tini/temar);
	for(i=1; i<=nmol; i++){
		vx[i]=vx[i]*st;
		vy[i]=vy[i]*st;
		vz[i]=vz[i]*st;
	}
}

