c-----------------------------------------------------------
c     Output for pvwin
c              Shigeo Maruyama 2000-8-7
c-----------------------------------------------------------
      program onlyoutput
      parameter(nunit=3, nmol=2)
      implicit double precision(a-h,o-z)
      dimension x(nmol,3), imask(nmol)
c-------------------------------------------------
c     constants
c-------------------------------------------------
      pi  = 4.0d0*atan(1.0d0)
      vl = 20D-10
c
      time = 0.0D0
      dt = 10.0D-15
      nrep = 2000
c-------------------------------------------------
c	Initial Condition
c-------------------------------------------------
      x(1,1)=10.0D-10
      x(1,2)=10.0D-10
      x(1,3)=10.0D-10
      x(2,1)=10.0D-10
      x(2,2)=10.0D-10
      x(2,3)=10.0D-10
      
c-------------------------------------------------
c	Output
c-------------------------------------------------
      open(13,file='pos.dat')
      open(14,file='mask.dat')
      write(13,*) 1,nmol,nrep
      write(13,'(3F7.1)') vl*1.0D10,vl*1.0D10,vl*1.0D10
      write(13,'(3F7.2)') time, dt*1.0D15
      do 30 i=1,nmol
          write(13,'(3F7.1)') (x(i,j)*1.0D10,j=1,3)
  30  continue
c-------------------------------------------------
c     Main routine
c-------------------------------------------------
      write(*,*) 'Main calculation started'
      do 500 irep=1,nrep
	x(1,1) = 15.0D-10-5.0D-10*cos(irep/50.0)
	x(2,1) = 5.0D-10+5.0D-10*cos(irep/50.0)
        imask(1) = abs(cos(irep/50.0))*16
        imask(2) = abs(cos(irep/50.0))*16
        
          do 570 i=1,nmol
            write(13,'(3F7.1)') (x(i,j)*1.0D10,j=1,3)
            write(14, *) imask(i)
  570     continue

  500 continue
      write(*,*) '-- program finished normally --'
      close(13)
      close(14)
c
      stop
      end
