/********************************************
 *          program make mask file          *
 *                                          *
 *         by Tasuto Kimura 1997.Jun        *
 ********************************************/
#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "malloc.h"

struct vec {double x,y,z;};
FILE *fpp,*fpt,*fpm,*fpg,*fpnv;

int count(void);
void center(int nmol,struct vec *pos,
            struct vec *pbuf,struct vec vl,struct vec *cent);

void main()
{
  struct vec *pos,*pbuf,vl,cent;

  double time,dt,pm,a;
  int    nmol,nscene,nv,i,j;

  printf("This program uses pos.dat & poten.dat\n");

  fpp=fopen("pos.dat","r");
  fpt=fopen("poten.dat","r");

  fpm=fopen("mask.dat","w");
  fpg=fopen("g.dat","w");
  fpnv=fopen("nv.dat","w");

  nscene=count();

  fscanf(fpp,"%d %d %d %lf %lf %lf %lf %lf",
         &i,&nmol,&i,&vl.x,&vl.y,&vl.z,&time,&dt);
  for(i=0;i<nmol;i++)
    fscanf(fpp,"%lf %lf %lf\n",&a,&a,&a);

  pos=(struct vec *)malloc(nmol*sizeof(struct vec));
  pbuf=(struct vec *)malloc(nmol*sizeof(struct vec));
  for(i=1;i<=nscene;i++){
    if((i%100)==0)
      printf("Now Step %d\n",i);

    for(j=0;j<nmol;j++)
      fscanf(fpp,"%lf %lf %lf\n",&pos[j].x,&pos[j].y,&pos[j].z);

    center(nmol,pos,pbuf,vl,&cent);

    nv=0;

    for(j=0;j<nmol;j++){
      fscanf(fpt,"%lf\n",&pm);
 
      if(pm>=-2.5){
        fprintf(fpm,"%d\n",15);
        nv++;
      }
      else if(pm>=-10.0)
        fprintf(fpm,"%d\n",12);
      else if(pm>=-12.0)
        fprintf(fpm,"%d\n",10);
      else
        fprintf(fpm,"%d\n",1);
    }
    time+=dt;
    fprintf(fpnv,"%7.2lf%5d\n",time,nv);
    fprintf(fpg,"%7.2lf%8.3lf%8.3lf%8.3lf\n",
            time,cent.x,cent.y,cent.z);
  }
  free((void *)pos);
  free((void *)pbuf);

  fclose(fpp);
  fclose(fpt);
  fclose(fpm);
  fclose(fpg);
  fclose(fpnv);
  
  printf("All calculations are done!\n");
}


/*************************************
 *      Count the number of data     *
 *************************************/
int count()
{
  int    nmol,ndata,ntemp,i;
  double a;

  fscanf(fpp,"%d %d %d %lf %lf %lf %lf %lf",
         &i,&nmol,&i,&a,&a,&a,&a,&a);
  printf("nmol= %d\n",nmol);

  i=0;
  ndata=0;
  while(!feof(fpp)){
    i++;
    fscanf(fpp,"%lf %lf %lf\n",&a,&a,&a);
    if(i==nmol){
      i=0;
      ndata++;
    }
  }

  i=0;
  ntemp=0;
  while(!feof(fpt)){
    i++;
    fscanf(fpt,"%lf\n",&a);
    if(i==nmol){
      i=0;
      ntemp++;
    }
  }

  printf("ndata,ntemp= %d %d\n",ndata,ntemp);
  if(ntemp<ndata)
    ndata=ntemp;
  printf("Total %d Scenes!\n",ndata);
  rewind(fpp);
  rewind(fpt);
  return(ndata);
}


/***************************************
 *    Calculate the center of liquid   *
 ***************************************/
void center(int nmol,struct vec *pos,
            struct vec *pbuf,struct vec vl,struct vec *cent)
{
  int i;
  double a;
  struct vec org,mom2a,mom2b;

  cent->x=0.0;
  cent->y=0.0;
  cent->z=0.0;

  for(i=0;i<nmol;i++){
    pbuf[i].x=pos[i].x-0.5*vl.x;
    pbuf[i].y=pos[i].y-0.5*vl.y;
    pbuf[i].z=pos[i].z-0.5*vl.z; 
    cent->x+=pbuf[i].x;
    cent->y+=pbuf[i].y;
    cent->z+=pbuf[i].z;
  }

  cent->x/=(double)nmol;
  cent->y/=(double)nmol;
  cent->z/=(double)nmol;
  
  org.x=pbuf[0].x;
  org.y=pbuf[0].y;

  while((fabs(cent->x) >= 1.0e-8)||(fabs(cent->y) >= 1.0e-8)){
    for(i=0;i<nmol;i++){
      pbuf[i].x-=cent->x;
      pbuf[i].y-=cent->y;
      pbuf[i].x-=vl.x*floor(pbuf[i].x/vl.x+0.5);
      pbuf[i].y-=vl.y*floor(pbuf[i].y/vl.y+0.5);
    }

    cent->x=0.0;
    cent->y=0.0;
    for(i=0;i<nmol;i++){
      cent->x+=pbuf[i].x;
      cent->y+=pbuf[i].y;
    }
    cent->x/=(double)nmol;
    cent->y/=(double)nmol;
  }

  mom2a.x=0.0;
  mom2a.y=0.0;
  mom2b.x=0.0;
  mom2b.y=0.0;

  for(i=0;i<nmol;i++){
    a=pbuf[i].x;
    mom2a.x+=a*a;
    if(a>0.0)
      a=0.5*vl.x-a;
    else
      a=0.5*vl.x+a;
    mom2b.x+=a*a;

    a=pbuf[i].y;
    mom2a.y+=a*a;
    if(a>0.0)
      a=0.5*vl.y-a;
    else
      a=0.5*vl.y+a;
    mom2b.y+=a*a;
  }

  if(mom2a.x<=mom2b.x)
    cent->x=org.x-pbuf[0].x;
  else
    cent->x=org.x-pbuf[0].x+0.5*vl.x;

  if(mom2a.y<=mom2b.y)
    cent->y=org.y-pbuf[0].y;
  else
    cent->y=org.y-pbuf[0].y+0.5*vl.y;

  cent->x+=-vl.x*floor(cent->x/vl.x+0.5)+0.5*vl.x;
  cent->y+=-vl.y*floor(cent->y/vl.y+0.5)+0.5*vl.y;
  cent->z+=0.5*vl.z;
} 
