c---------------------------------------------------------------------
c            MD for Ar
c
c                   by Tatsuto Kimura      1997.Jun
c
c                          periodic boundary
c---------------------------------------------------------------------
c     Files
c       10    Calculation Condition
c       11    Continuing Data from Previous Calc
c       12    Continuing Data for Next Calc
c       13    Output of position
c       14    Output of energy
c       15    Output of potential
c       16    Output of velocity
c---------------------------------------------------------------------
c	Main Program (periodic)
c---------------------------------------------------------------------
      program periodic
      implicit double precision(a-h,o-z)
      parameter(maxar=1372)
      common
     #     x(maxar),y(maxar),z(maxar),
     #     vx(maxar),vy(maxar),vz(maxar),
     #     fx(maxar),fy(maxar),fz(maxar),
     #     vlx,vly,vlz,vlxi,vlyi,vlzi,wmar,time,
     #     nmolar
      common /integ/
     #     dt,cfar
      common /tc/
     #     tini
c----------------------------------------------------------------
c	Opening files
c----------------------------------------------------------------
      open(10,file='periodic.dat')
      open(11,file='pre.dat')
c     open(12,file='nex.dat')
      open(13,file='pos.dat')
      open(14,file='ene.dat')
      open(15,file='poten.dat')
      open(16,file='vel.dat')
c----------------------------------------------------------------
c	Initialization of variables
c----------------------------------------------------------------
      call init(nrep,intp,inte,intc,ntc,dvlz)
c--------------------------------------------
c	output of initial condition
c--------------------------------------------
      write(13,*) 1,nmolar,nrep/intp+1
      write(13,'(3F8.3)') vlx*1.0D10,vly*1.0D10,
     +                           (vlz+dvlz*dble(nrep))*1.0D10
      write(13,'(2F7.2)') time*1.0D12,dt*dble(intp)*1.0D12
      do 150 i=1,nmolar
         write(13,'(3F8.3)') x(i)*1.0D10,y(i)*1.0D10,z(i)*1.0D10
         write(16,'(3F7.1)') vx(i),vy(i),vz(i)
 150  continue
c----------------------------------------------------------------
c	List vector of Ar-Ar
c----------------------------------------------------------------
      call arlist
c----------------------------------------------------------------
c     Calculation of Ar-Ar force
c----------------------------------------------------------------
      call forlj
c---------------------------------------------------------------------
c	TOP OF MAIN LOOP
c---------------------------------------------------------------------
      do 1000 irep=1,nrep
         if(mod(irep,100).eq.0)then
            write(*,*) irep
         endif
         time=time+dt
         vlz=vlz+dvlz
         vlzi=1.0D0/vlz
c----------------------------------------------------------------
c	Motion of molecules
c----------------------------------------------------------------
         call step
c--------------------------------------------
c	Output of position and velocity (13,16)
c--------------------------------------------
         if(mod(irep,intp).eq.0)then
            do 1250 i=1,nmolar
               vxt=vx(i)+0.5D0*fx(i)*cfar
               vyt=vy(i)+0.5D0*fy(i)*cfar
               vzt=vz(i)+0.5D0*fz(i)*cfar
               write(13,'(3F8.3)') x(i)*1.0D10,y(i)*1.0D10,z(i)*1.0D10
               write(16,'(3F7.1)') vxt,vyt,vzt
 1250       continue
         endif
c
         if(mod(irep,inte).eq.0)then
c----------------------------------------------------------------
c	calculation of energy
c----------------------------------------------------------------
            call ene(temar,ekt,ept,irep,intp)
c--------------------------------------------
c     Output of temperature and energy (14)
c--------------------------------------------
            write(14,'(F7.2,2F4.1,F6.1,E10.3,E11.3)') time*1.0D12,
     +           0.0D0,0.0D0,temar,ekt,ept
c----------------------------------------------------------------
c	temperature control
c----------------------------------------------------------------
            if(irep.le.ntc)then
               st=dsqrt(tini/temar)
               do 1320 i=1,nmolar
                  vx(i)=vx(i)*st
                  vy(i)=vy(i)*st
                  vz(i)=vz(i)*st
 1320          continue
            endif
c
         endif
c----------------------------------------------------------------
c	output of continuing data (12)
c----------------------------------------------------------------
         if(mod(irep,intc).eq.0)then
            open(12,file='nex'//char(irep/intc+48)//'.dat')
c
            write(12,'(d15.8)') time
            write(12,'(1h ,z16)') vlz
            write(12,'(3(1h ,z16))')
     +           (x(i),y(i),z(i),i=1,nmolar)
            write(12,'(3(1h ,z16))')
     +           (vx(i),vy(i),vz(i),i=1,nmolar)
c
            close(12)
         endif
c---------------------------------------------------------------------
c	END OF MAIN LOOP
c---------------------------------------------------------------------
 1000 continue
      write(*,*) '-- program finished normally --'
c----------------------------------------------------------------
c	Closing Files
c----------------------------------------------------------------
      close(10)
      close(11)
c     close(12)
      close(13)
      close(14)
      close(15)
      close(16)
c
      stop
      end
c
c
c---------------------------------------------------------------------
c	Generation of random number (ranf)
c---------------------------------------------------------------------
      double precision function ranf()
      implicit double precision(a-h,o-z)
      common /ran/
     #     nrdm
c
      jl=mod(nrdm,4096)
      jh=(nrdm-jl)/4096
      jl=jl*1899
      jll=mod(jl,4096)
      jlh=(jl-jll)/4096
      jh=mod(jh*1899+jlh,2048)
      nrdm=jh*4096+jll
      ranf=dble(nrdm)/8388608.0D0
      return
      end
c
c
c---------------------------------------------------------------------
c	Initializaion of variables (init)
c---------------------------------------------------------------------
      subroutine init(nrep,intp,inte,intc,ntc,dvlz)
      implicit double precision(a-h,o-z)
      parameter(maxar=1372)
      common
     #     x(maxar),y(maxar),z(maxar),
     #     vx(maxar),vy(maxar),vz(maxar),
     #     fx(maxar),fy(maxar),fz(maxar),
     #     vlx,vly,vlz,vlxi,vlyi,vlzi,wmar,time,
     #     nmolar
      common /integ/
     #     dt,cfar
      common /poten/
     #     sar2,ear4,ear48,
     #     sfp1ar,sfp2ar,sffar
      common /tc/
     #     tini
      common /cutoff/
     #     rlar2,rcar2,rlcar2
      common /ran/
     #     nrdm
c-------------------------------------------------
c    Constants
c-------------------------------------------------
      pi  = 4.0D0*atan(1.0D0)
      bk  = 1.38066D-23
      an  = 6.02217D23
c-----------------------------------------------------------
c     Reading calculation conditions (10)
c-----------------------------------------------------------
      read(10,*) nxyuni
      read(10,*) nzuni
      read(10,*) tini
      read(10,*) dt
      read(10,*) nrep
      read(10,*) intp
      read(10,*) inte
      read(10,*) intc
      read(10,*) ntc
      read(10,*) nrdm
      read(10,*) vlx
      read(10,*) vly
      read(10,*) vlz
      read(10,*) rl
      read(10,*) rc
      read(10,*) dvlz
c-------------------------------------------------
c     Parameter of molecules
c-------------------------------------------------
      sigar = 3.40D-10
      epsar = 1.67D-21
      wmar  = 39.948D-3/an
c-------------------------------------------------
c     Cut off parameters
c-------------------------------------------------
      rlar   = rl*sigar
      rlar2  = rlar*rlar
      rcar   = rc*sigar
      rcar2  = rcar*rcar
      rlcar  = rlar-rcar
      rlcar2 = rlcar*rlcar
c-------------------------------------------------
c     parameters for potential and force calculation
c-------------------------------------------------
      sar2 = sigar*sigar
      ear4 =  4.0D0*epsar
      ear48 = 48.0D0*epsar
c     
      rci6 = (1.0D0/rc)**6
      sf1  = 12.0D0*(2.0D0*rci6-1.0D0)*rci6
      sf2  =  4.0D0*(7.0D0*rci6-4.0D0)*rci6
c     
      sfp1ar = sf1*epsar/rcar2
      sfp2ar = sf2*epsar
      sffar  = sfp1ar*2.0D0
c-------------------------------------------------
c    Parameter of numerial integration
c-------------------------------------------------
      cfar = dt/wmar
c-------------------------------------------------
c     number of molecules
c-------------------------------------------------
      nmolar = 4*nxyuni*nxyuni*nzuni
c-------------------------------------------------
c    Size of calculation domain
c-------------------------------------------------
      vlxi = 1.0D0/vlx
      vlyi = 1.0D0/vly
      vlzi = 1.0D0/vlz
c-----------------------------------------------------------
c     Initializaion of position of velocity
c-----------------------------------------------------------
c------------------------------------------------------
c     Reading from previous calculation (11)
c------------------------------------------------------
      read(11,*,end=1000) time
      read(11,'(z17)',end=1000) vlz
      read(11,'(3z17)',end=1000)
     +     (x(i),y(i),z(i),i=1,nmolar)
      read(11,'(3z17)',end=1000)
     +     (vx(i),vy(i),vz(i),i=1,nmolar)
c     
      vlzi = 1.0D0/vlz
      write(*,*) 'read previous consequence as initial condition.'
      goto 3000
c------------------------------------------------------
c     Newly define
c------------------------------------------------------
 1000  continue
c-------------------------------------------------
c     Size of argon unit crystal
c-------------------------------------------------
      ulx=vlx/dble(nxyuni)
      uly=vly/dble(nxyuni)
      ulz=vlz/dble(nzuni)
      ul=dmin1(ulx,uly,ulz)
c-------------------------------------------------
c     Initializaion of time
c-------------------------------------------------
      time=0.0D0
c-------------------------------------------------
c     Position of gravity center
c-------------------------------------------------
c---------------------------------------
c     Ar
c---------------------------------------
      im=0
      basex=0.5D0*(vlx-dble(nxyuni)*ul)
      basey=0.5D0*(vly-dble(nxyuni)*ul)
      basez=0.5D0*(vlz-dble(nzuni)*ul)
      do 1300 k=0,nzuni-1
         do 1300 j=0,nxyuni-1
            do 1300 i=0,nxyuni-1
               im=im+1
               x(im)=ul*(0.25D0+dble(i))+basex
               y(im)=ul*(0.25D0+dble(j))+basey
               z(im)=ul*(0.25D0+dble(k))+basez
               im=im+1
               x(im)=ul*(0.75D0+dble(i))+basex
               y(im)=ul*(0.25D0+dble(j))+basey
               z(im)=ul*(0.75D0+dble(k))+basez
               im=im+1
               x(im)=ul*(0.25D0+dble(i))+basex
               y(im)=ul*(0.75D0+dble(j))+basey
               z(im)=ul*(0.75D0+dble(k))+basez
               im=im+1
               x(im)=ul*(0.75D0+dble(i))+basex
               y(im)=ul*(0.75D0+dble(j))+basey
               z(im)=ul*(0.25D0+dble(k))+basez
 1300 continue
c-------------------------------------------------
c     velocity of molecules
c-------------------------------------------------
c---------------------------------------
c     Ar
c---------------------------------------
      do 1800 i=1,nmolar
         coef=dsqrt((3.0D0*bk*tini)/wmar)
         a=ranf()*pi*2.0D0
         b=(ranf()-0.5D0)*pi
         vx(i)=coef*dcos(b)*dsin(a)
         vy(i)=coef*dcos(b)*dcos(a)
         vz(i)=coef*dsin(b)
 1800 continue
c-------------------------------------------------
c     Stop the total translation
c-------------------------------------------------
c---------------------------------------
c     Ar
c---------------------------------------
      vtx=0.0D0
      vty=0.0D0
      vtz=0.0D0
      do 2300 i=1,nmolar
         vtx=vtx+vx(i)
         vty=vty+vy(i)
         vtz=vtz+vz(i)
 2300 continue
      vtx=vtx/dble(nmolar)
      vty=vty/dble(nmolar)
      vtz=vtz/dble(nmolar)
      do 2350 i=1,nmolar
         vx(i)=vx(i)-vtx
         vy(i)=vy(i)-vty
         vz(i)=vz(i)-vtz
 2350 continue
c     
 3000 continue
      return
      end
c
c
c---------------------------------------------------------------------
c	Generation of Ar-Ar list (arlist)
c---------------------------------------------------------------------
      subroutine arlist
      implicit double precision(a-h,o-z)
      parameter(maxar=1372)
      common
     #     x(maxar),y(maxar),z(maxar),
     #     vx(maxar),vy(maxar),vz(maxar),
     #     fx(maxar),fy(maxar),fz(maxar),
     #     vlx,vly,vlz,vlxi,vlyi,vlzi,wmar,time,
     #     nmolar
      common /list/
     #     iarlst(maxar-1),jarlst(maxar*(maxar-1)/2)
      common /dr/
     #     dlx(maxar),dly(maxar),dlz(maxar)
      common /cutoff/
     #     rlar2,rcar2,rlcar2
c-------------------------------------------------
c     Ar-Ar
c-------------------------------------------------
      nlst=1
      do 100 i=1,nmolar-1
         rix=x(i)
         riy=y(i)
         riz=z(i)
         njlst=0
         do 110 j=i+1,nmolar
            rx=rix-x(j)
            ry=riy-y(j)
            rz=riz-z(j)
            rx=rx-dnint(rx*vlxi)*vlx
            ry=ry-dnint(ry*vlyi)*vly
            rz=rz-dnint(rz*vlzi)*vlz
            r2=rx*rx+ry*ry+rz*rz
            jarlst(nlst)=j
            n=idint(0.5D0+dsign(0.5D0,rlar2-r2))
            nlst=nlst+n
            njlst=njlst+n
 110     continue
         iarlst(i)=njlst
 100  continue
c-------------------------------------------------
c     Initializaion of difference in position
c-------------------------------------------------
      do 200 i=1,nmolar
         dlx(i)=0.0D0
         dly(i)=0.0D0
         dlz(i)=0.0D0
 200  continue
c
      return
      end
c     
c     
c---------------------------------------------------------------------
c                           Move molecules (step)
c---------------------------------------------------------------------
      subroutine step
      implicit double precision(a-h,o-z)
      parameter(maxar=1372)
      common
     #     x(maxar),y(maxar),z(maxar),
     #     vx(maxar),vy(maxar),vz(maxar),
     #     fx(maxar),fy(maxar),fz(maxar),
     #     vlx,vly,vlz,vlxi,vlyi,vlzi,wmar,time,
     #     nmolar
      common /dr/
     #     dlx(maxar),dly(maxar),dlz(maxar)
      common /integ/
     #     dt,cfar
      common /tc/
     #     tini
      common /cutoff/
     #     rlar2,rcar2,rlcar2
c-----------------------------------------------------------
c     Renewal of velocity
c-----------------------------------------------------------
      do 200 i=1,nmolar
         vx(i)=vx(i)+fx(i)*cfar
         vy(i)=vy(i)+fy(i)*cfar
         vz(i)=vz(i)+fz(i)*cfar
 200  continue
c-----------------------------------------------------------
c     Renewal of position
c-----------------------------------------------------------
      do 300 i=1,nmolar
         dx=vx(i)*dt
         dy=vy(i)*dt
         dz=vz(i)*dt
         x(i)=x(i)+dx
         y(i)=y(i)+dy
         z(i)=z(i)+dz
         x(i)=x(i)-dnint(x(i)*vlxi-0.5D0)*vlx
         y(i)=y(i)-dnint(y(i)*vlyi-0.5D0)*vly
         z(i)=z(i)-dnint(z(i)*vlzi-0.5D0)*vlz
c
         dlx(i)=dlx(i)+dx
         dly(i)=dly(i)+dy
         dlz(i)=dlz(i)+dz
 300  continue
c-----------------------------------------------------------
c     Checking neighbor list
c-----------------------------------------------------------
c-------------------------------------------------
c     Ar-Ar
c-------------------------------------------------
      armax=0.0D0
      do 2000 i=1,nmolar
         dl2=dlx(i)*dlx(i)+dly(i)*dly(i)+dlz(i)*dlz(i)
         armax=dmax1(armax,dl2)
 2000 continue
      if(armax*4.0D0.gt.rlcar2) call arlist
c-----------------------------------------------------------
c     Calculation of (Ar-Ar) intermolecular force
c-----------------------------------------------------------
      call forlj
c     
      return
      end
c
c
c---------------------------------------------------------------------
c	Calculation of intermolecular force (forlj)
c---------------------------------------------------------------------
      subroutine forlj
      implicit double precision(a-h,o-z)
      parameter(maxar=1372)
      common
     #     x(maxar),y(maxar),z(maxar),
     #     vx(maxar),vy(maxar),vz(maxar),
     #     fx(maxar),fy(maxar),fz(maxar),
     #     vlx,vly,vlz,vlxi,vlyi,vlzi,wmar,time,
     #     nmolar
      common /list/
     #     iarlst(maxar-1),jarlst(maxar*(maxar-1)/2)
      common /poten/
     #     sar2,ear4,ear48,
     #     sfp1ar,sfp2ar,sffar
      common /cutoff/
     #     rlar2,rcar2,rlcar2
c--------------------------------------------
c     Clearing force
c--------------------------------------------
      do 100 i=1,nmolar
         fx(i)=0.0D0
         fy(i)=0.0D0
         fz(i)=0.0D0
 100  continue
c-------------------------------------------------
c     Ar-Ar
c-------------------------------------------------
      nlst=0
      do 400 i=1,nmolar-1
         njlst=iarlst(i)
         rix=x(i)
         riy=y(i)
         riz=z(i)
         fix=fx(i)
         fiy=fy(i)
         fiz=fz(i)
         do 410 j=1,njlst
            nlst=nlst+1
            jm=jarlst(nlst)
c
            rx=rix-x(jm)
            ry=riy-y(jm)
            rz=riz-z(jm)
            rx=rx-dnint(rx*vlxi)*vlx
            ry=ry-dnint(ry*vlyi)*vly
            rz=rz-dnint(rz*vlzi)*vlz
c
            r2=rx*rx+ry*ry+rz*rz
            r2i=1.0D0/r2
c
            sbr2=sar2*r2i
            sbr6=sbr2*sbr2*sbr2
            sl=0.5D0+dsign(0.5D0,rcar2-r2)
            dflj=(ear48*(sbr6-0.5D0)*sbr6*r2i-sffar)*sl
            dfx=dflj*rx
            dfy=dflj*ry
            dfz=dflj*rz
c
            fix=fix+dfx
            fiy=fiy+dfy
            fiz=fiz+dfz
            fx(jm)=fx(jm)-dfx
            fy(jm)=fy(jm)-dfy
            fz(jm)=fz(jm)-dfz
 410     continue
         fx(i)=fix
         fy(i)=fiy
         fz(i)=fiz
 400  continue
c
      return
      end
c
c
c---------------------------------------------------------------------
c                          Energy (ene)
c---------------------------------------------------------------------
      subroutine ene(temar,ekt,ept,irep,intp)
      implicit double precision(a-h,o-z)
      parameter(maxar=1372)
      dimension ep(maxar)
      common
     #     x(maxar),y(maxar),z(maxar),
     #     vx(maxar),vy(maxar),vz(maxar),
     #     fx(maxar),fy(maxar),fz(maxar),
     #     vlx,vly,vlz,vlxi,vlyi,vlzi,wmar,time,
     #     nmolar
      common /list/
     #     iarlst(maxar-1),jarlst(maxar*(maxar-1)/2)
      common /poten/
     #     sar2,ear4,ear48,
     #     sfp1ar,sfp2ar,sffar
      common /cutoff/
     #     rlar2,rcar2,rlcar2
c-------------------------------------------------
c     Constants
c-------------------------------------------------
      bk  = 1.38066D-23
c-----------------------------------------------------------
c    Kinetic energy and temperature
c-----------------------------------------------------------
c------------------------------------------------------
c     Ar
c------------------------------------------------------
      ektar=0.0D0
      do 300 i=1,nmolar
         ektar=ektar+vx(i)*vx(i)+vy(i)*vy(i)+vz(i)*vz(i)
 300  continue
      ektar=0.5D0*wmar*ektar
      temar=2.0D0*ektar/(dble(nmolar)*3.0D0*bk)
c------------------------------------------------------
c     Kinetic energy of whole system
c------------------------------------------------------
      ekt=ektar
c-----------------------------------------------------------
c     Potential energy
c-----------------------------------------------------------
      do 400 i=1,nmolar
         ep(i)=0.0D0
 400  continue
      ept=0.0D0
c------------------------------------------------------
c     L-J potential
c------------------------------------------------------
c-------------------------------------------------
c     Ar-Ar
c-------------------------------------------------
      nlst=0
      do 900 i=1,nmolar-1
         njlst=iarlst(i)
         rix=x(i)
         riy=y(i)
         riz=z(i)
         eip=ep(i)
         do 910 j=1,njlst
            nlst=nlst+1
            jm=jarlst(nlst)
c
            rx=rix-x(jm)
            ry=riy-y(jm)
            rz=riz-z(jm)
            rx=rx-dnint(rx*vlxi)*vlx
            ry=ry-dnint(ry*vlyi)*vly
            rz=rz-dnint(rz*vlzi)*vlz
c
            r2=rx*rx+ry*ry+rz*rz
c
            sbr2=sar2/r2
            sbr6=sbr2*sbr2*sbr2
            sl=0.5D0+dsign(0.5D0,rcar2-r2)
c            dlj=(ear4*(sbr6-1.0D0)*sbr6+sfp1ar*r2-sfp2ar)*sl
            dlj=(ear4*(sbr6-1.0D0)*sbr6)*sl
c
            eip=eip+dlj
            ep(jm)=ep(jm)+dlj
            ept=ept+dlj
 910     continue
c ---------long range correction for each molecules
 	sigar = dsqrt(sar2)
 	rc = dsqrt(rcar2)/sigar
 	rhostar = nmolar/vlx/vly/vlz*sigar**3
 	pi = 3.1415926535897932384626433832795
 	epsar = ear4/4.0
 	ept = ept + 8.0*pi*rhostar/3.0/rc**3*(1.0/3.0/rc**6 - 1.0)*epsar
c----------------------------------------
         ep(i)=eip
 900  continue
c-----------------------------------------------------------
c     Output of results
c-----------------------------------------------------------
      if(mod(irep,intp).eq.0)then
         do 1050 i=1,nmolar
            write(15,'(F7.2)') ep(i)*1.0D21
 1050    continue
      endif
c
      return
      end
