c---------------------------------------------------------------------
c                   Pressure Calculation for Argon
c
c                   by Tatsuto KIMURA     2000.May
c
c                    Periodic Boundary Condition
c---------------------------------------------------------------------
      program press
      implicit double precision(a-h,o-z)
      parameter(maxar=4000)
      dimension
     #     x(maxar),y(maxar),z(maxar)
c-------------------------------------------------
c     Constants
c-------------------------------------------------
      pi=4.0D0*datan(1.0D0)
      sar=3.40D0
      ear=1.67D-21
      an=6.02217D23
      wmar=39.948D-3/an
c-----------------------------------------------------------
c     Open Files
c-----------------------------------------------------------
      open(10,file='pos.dat')
      open(11,file='vel.dat')
      open(12,file='press.dat')
c-----------------------------------------------------------
c     Read Parameters
c-----------------------------------------------------------
      read(10,*) i,nmolar,nrep,vlx,vly,vlz,time,dt
c-------------------------------------------------
c     Cell Size
c-------------------------------------------------
      vlxi=1.0D0/vlx
      vlyi=1.0D0/vly
      vlzi=1.0D0/vlz
      voli=vlxi*vlyi*vlzi
c-------------------------------------------------
c     Virial Parameter
c-------------------------------------------------
      sar2=sar*sar
      sar3=sar*sar2
c
      rcar=dmin1(vlx,vly,vlz)*0.5D0
      rcar2=rcar*rcar
      sbrc=sar/rcar
      sbrc3=sbrc*sbrc*sbrc
      sbrc6=sbrc3*sbrc3
c
      rho=dble(nmolar)*voli
c
      virirc=2.0D0/9.0D0*pi*rho*sar3*(sbrc6-1.5D0)*sbrc3*dble(nmolar)
c
      cf=1.0D30*voli/3.0D0
      ekcf=cf*wmar
      viricf=cf*ear*48.0D0
c----------------------------------------------------------------
c     Main Loop
c----------------------------------------------------------------
      do 1000 irep=1,nrep
         read(10,*) (x(i),y(i),z(i),i=1,nmolar)
c-----------------------------------------------------------
c     Kinetic Part
c-----------------------------------------------------------
         ek=0.0D0
         do 1100 i=1,nmolar
            read(11,*) vx,vy,vz
            ek=ek+vx*vx+vy*vy+vz*vz
 1100    continue
c-----------------------------------------------------------
c     Virial Part
c-----------------------------------------------------------
         viri=0.0D0
         do 1200 i=1,nmolar-1
            rix=x(i)
            riy=y(i)
            riz=z(i)
            do 1250 j=i+1,nmolar
               rx=rix-x(j)
               ry=riy-y(j)
               rz=riz-z(j)
               rx=rx-dnint(rx*vlxi)*vlx
               ry=ry-dnint(ry*vlyi)*vly
               rz=rz-dnint(rz*vlzi)*vlz
c
               r2=rx*rx+ry*ry+rz*rz
c-----for linux compiler----------------
c               sbr2=sar2/r2
c               sbr6=sbr2*sbr2*sbr2
c               sl=0.5D0+dsign(0.5D0,rcar2-r2)
c               viri=viri+(sbr6-0.5D0)*sbr6*sl
c-----for nt compiler-------------------
            if(r2.lt.rcar2)then
               sbr2=sar2/r2
               sbr6=sbr2*sbr2*sbr2
               viri=viri+(sbr6-0.5D0)*sbr6
            endif
c---------------------------------------
 1250       continue
 1200    continue
c-----for homogeneous system------------
c         viri=viri+virirc
c---------------------------------------
c-----------------------------------------------------------
c     Output (12)
c-----------------------------------------------------------
         ek=ek*ekcf
         viri=viri*viricf
         write(12,'(F8.2,3(1X,E10.3))')
     +             time+dt*dble(irep-1),ek,viri,ek+viri
c----------------------------------------------------------------
c     End of Main Loop
c----------------------------------------------------------------
 1000 continue
c-----------------------------------------------------------
c     Close Files
c-----------------------------------------------------------
      close(10)
      close(11)
      close(12)
c
      stop
      end
