#include <stdio.h>
#include <math.h>
#define n 501

double f[n], f1[n], f2[n], f3[n], eta[n];
double F[n], theta[n];
double c1, Pr;

void main(void)
{
	int i;
	double de;
	
	printf("#f2[0]:");
	scanf("%lf", &f2[0]);
	
/* calculation of flow field  */
	de=10.0/(double)(n-1);
	for(i=0; i<n; i++){
		eta[i]=(double)i*de;
	}
	f[0]=f1[0]=0.0;
	
	for(i=1; i<n; i++){
		f3[i]=-0.5*f[i-1]*f2[i-1];
		f2[i]=f2[i-1]+f3[i]*de;
		f1[i]=f1[i-1]+f2[i]*de;
		f[i]=f[i-1]+f1[i]*de;
	}

/* calculation of temperature field  */
	printf("Pr:");
	scanf("%lf", &Pr);
	F[0]=0.0;
	for(i=1; i<n; i++){
		F[i]=F[i-1]+f[i-1]*de;
	}
	
	theta[0]=0.0;
	for(i=1; i<n; i++) theta[i]=theta[i-1] + exp(-0.5*Pr*F[i-1])*de;
	c1=theta[n-1];
	for(i=0; i<n; i++) theta[i]=1.0-theta[i]/c1;
	printf("# eta   f'   theta   Pr=%lf\n", Pr);
	for(i=0; i<n; i=i+10) printf("%lf  %lf  %lf\n", eta[i],f1[i], theta[i]);
}
