/********************************************
 *            program pv compiler           *
 *                display wall              *
 *                                          *
 *         by Tasuto Kimura 1997.Jun        *
 ********************************************/
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "malloc.h"

struct header{ 
  char string[32];
  unsigned short moltype,nmol,nbond,ndata;
  double vlx1,vlx2,vly1,vly2,vlz1,vlz2,time0,dt;
};

#pragma pack(1)
struct atom{
  unsigned char attr;
  short x,y,z;
};
#pragma pack()

FILE *fpp,*fpw,*fpm,*fppv;

void fillatombuf(char readattr,int nmol,struct atom *atombuf,FILE *fp);

void main(int argc,char *argv[])
{
  struct header h;
  struct atom *atombuf,*watombuf;
  double s[3];
  int i;
  unsigned short nmol,nmolw;

  if(argc!=3){
    printf("Usage : pvc <mask.dat> <pos.pv>\n");
    exit(0);
  }
  printf("This program uses pos.dat & wpos.dat\n");

  fpp=fopen("pos.dat","r");
  fpw=fopen("wpos.dat","r");
  fpm=fopen(argv[1],"r");

  fppv=fopen(argv[2],"wb");

  strncpy(h.string,"PV-01 /Shoji-Maruyama Laboratory",32);
  h.nbond=0;
  h.vlx1=0.0;
  h.vly1=0.0;
  h.vlz1=0.0;
  fscanf(fpw,"%u %u %u %lf %lf %lf %lf %lf",
	 &h.moltype,&nmolw,&h.ndata,
	 &h.vlx2,&h.vly2,&h.vlz2,&h.time0,&h.dt);
  fscanf(fpp,"%u %u %u %lf %lf %lf %lf %lf",
	 &h.moltype,&nmol,&h.ndata,
	 &h.vlx2,&h.vly2,&h.vlz2,&h.time0,&h.dt);
  h.nmol=nmol+nmolw;
  fwrite(&h,sizeof(h),1,fppv);

  switch(h.moltype){
  case 1:
    s[0]=1.0;
    break;
  case 2:
    s[0]=1.2;
    s[1]=0.6;
    break;
  case 3:
    s[0]=1.2;
    s[1]=0.6;
    s[2]=0.6;
    break;
  }
  fwrite(s,sizeof(double),h.moltype,fppv);

  for(i=1;i<=h.ndata;i++){
    if((i%100)==0)
      printf("step %d\n",i);
    
    watombuf=(struct atom *)malloc(nmolw*sizeof(struct atom));
    fillatombuf(2,nmolw,watombuf,fpw);
    fwrite(watombuf,sizeof(struct atom),nmolw,fppv);
    free((void *)watombuf);

    atombuf=(struct atom *)malloc(nmol*sizeof(struct atom));
    fillatombuf((i>1),nmol,atombuf,fpp);
    fwrite(atombuf,sizeof(struct atom),nmol,fppv);
    free((void *)atombuf);
  }

  fclose(fpp);
  fclose(fpw);
  fclose(fpm);
  fclose(fppv);
}


void fillatombuf(char readattr,int nmol,struct atom *atombuf,FILE *fp)
{
  double x,y,z;
  int i,m;
  
  for(i=0;i<nmol;i++){
    if(readattr==0)
      m=0;
    else if(readattr==2)
      m=14;
    else
      fscanf(fpm,"%d",&m);
    atombuf[i].attr=(unsigned char)m;

    fscanf(fp,"%lf %lf %lf",&x,&y,&z);
    atombuf[i].x=(short)(x*100);
    atombuf[i].y=(short)(y*100);
    atombuf[i].z=(short)(z*100);
  }
}
