//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "MainUnit.h"
#include "EditUnit.h"
#include "InfoUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
	FILE *fc;
	char linebuf[256];
	int i,j,r,g,b;
	AnsiString filename,line;

	DragAcceptFiles(Handle,true);

	FGColor=clWhite;
	BGColor=clBlack;

	BallBitmap=new Graphics::TBitmap;
	filename=ExtractFilePath(Application->ExeName)+"ball.bmp";
	if(FileExists(filename)){
		try{
			BallBitmap->LoadFromFile(filename);
		}
		catch(...){
			Application->MessageBox("\"ball.bmp\" is incorrect!","PVWin",MB_OK+MB_ICONWARNING);
		}
	}
	else
		Application->MessageBox("Put \"ball.bmp\" with \"PVWIN.exe\"!","PVWin",MB_OK+MB_ICONWARNING);

	MkMenuImageList();

	ScreenBitmap=new Graphics::TBitmap;
	ScreenBitmap->PixelFormat=pf24bit;
	ScreenBitmap->Canvas->Font->Color=FGColor;
	ScreenBitmap->Canvas->Font->Size=12;

	BallMag=1.0;
	Screen=-5.0;
	ViewPoint=1;

	Alpha=0;
	CA=1.0;
	SA=0.0;
	Beta=0;
	CB=1.0;
	SB=0.0;

	RX=1.0;
	RY=1.0;
	RZ=1.0;

	Step=1;

	TimeX=ClientWidth;
	TimeY=0;

	if(ParamCount()>0){
		OpenDialog->FileName=ParamStr(1);
		SaveDialog->InitialDir=ExtractFilePath(OpenDialog->FileName);
		FileOpen();
		return;
	}

	fc=fopen((ExtractFilePath(Application->ExeName)+"pvwin.cfg").c_str(),"r");
	if(fc!=NULL){
		while(!feof(fc)){
			line=fgets(linebuf,256,fc);
			i=line.AnsiPos(":");
			if(i!=0){
				if(line.SubString(1,i-1).Trim()=="top"){
					try{
						Top=StrToInt(line.SubString(i+1,255).Trim());
					}
					catch(...){
						Application->MessageBox("\"pvwin.cfg\" is incorect!\n\n\"top\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
					}
				}
				if(line.SubString(1,i-1).Trim()=="left"){
					try{
						Left=StrToInt(line.SubString(i+1,255).Trim());
					}
					catch(...){
						Application->MessageBox("\"pvwin.cfg\" is incorect!\n\n\"left\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
					}
				}
				if(line.SubString(1,i-1).Trim()=="width"){
					try{
						ClientWidth=StrToInt(line.SubString(i+1,255).Trim());
					}
					catch(...){
						Application->MessageBox("\"pvwin.cfg\" is incorect!\n\n\"width\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
					}
				}
				if(line.SubString(1,i-1).Trim()=="height"){
					try{
						ClientHeight=StrToInt(line.SubString(i+1,255).Trim());
					}
					catch(...){
						Application->MessageBox("\"pvwin.cfg\" is incorect!\n\n\"height\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
					}
				}
				if(line.SubString(1,i-1).Trim()=="foreground color(R,G,B)"){
					try{
						line=line.SubString(i+1,255).Trim();
						sscanf(line.c_str(),"%d,%d,%d",&r,&g,&b);
						FGColor=(TColor)(r+256*g+256*256*b);
						ScreenBitmap->Canvas->Font->Color=FGColor;
						ColorDialog->CustomColors->Add("ColorA="+IntToHex((int)FGColor,6));
					}
					catch(...){
						Application->MessageBox("\"pvwin.cfg\" is incorect!\n\n\"foreground color(R,G,B)\" must be list of integers.","PVWin",MB_OK+MB_ICONWARNING);
					}
				}
				if(line.SubString(1,i-1).Trim()=="background color(R,G,B)"){
					try{
						line=line.SubString(i+1,255).Trim();
						sscanf(line.c_str(),"%d,%d,%d",&r,&g,&b);
						BGColor=(TColor)(r+256*g+256*256*b);
						MainForm->Color=BGColor;
						ColorDialog->CustomColors->Add("ColorB="+IntToHex((int)BGColor,6));
					}
					catch(...){
						Application->MessageBox("\"pvwin.cfg\" is incorect!\n\n\"background color(R,G,B)\" must be list of integers.","PVWin",MB_OK+MB_ICONWARNING);
					}
				}
			}
		}
	}
	fclose(fc);

	NScene=0;
	NAtomSize=1;
	AtomSize=new double[NAtomSize];
	AtomSize[0]=1.0;

	ScreenBitmap->Width=ClientWidth;
	ScreenBitmap->Height=ClientHeight;
	ScreenBitmap->Canvas->Brush->Style=bsSolid;
	ScreenBitmap->Canvas->Brush->Color=BGColor;
	ScreenBitmap->Canvas->Pen->Color=BGColor;
	ScreenBitmap->Canvas->Rectangle(0,0,ClientWidth,ClientHeight);
	MkBallImageList();
	for(i=0;i<16;i++){
		for(j=0;j<16;j++){
			BallImageList->Draw(ScreenBitmap->Canvas,
			      (j-8)*21+ClientWidth/2+8,(i-8)*21+ClientHeight/2+8,i,true);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::WMDropFiles(TWMDropFiles &Msg)
{
	char filename[MAX_PATH];

	DragQueryFile((HDROP)Msg.Drop,0,filename,MAX_PATH);
	OpenDialog->FileName=filename;
	SaveDialog->InitialDir=ExtractFilePath(OpenDialog->FileName);
	delete[] Atom;
	delete[] Bond;
	delete[] Distance;
	delete[] CompList;
	delete[] AtomSize;
	delete[] AtomList;
	delete[] DispMol;
	delete[] Numbered;
	Refresh();
	FileOpen();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
	if((NScene!=0)&&(Button==mbLeft)){
		Mx0=X;
		My0=Y;
		A0=Alpha;
		B0=Beta;
	}
	if((NScene!=0)&&(Button==mbRight)){
		Mx0=X;
		My0=Y;
		Sx0=ShiftX;
		Sy0=ShiftY;
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormMouseMove(TObject *Sender,
			TShiftState Shift, int X, int Y)
{
	if(Shift.Contains(ssLeft)&&(NScene!=0)&&((Mx0!=X)||(My0!=Y))){
		Alpha=A0+((Mx0-X)-(Mx0-X)/360*360)/2;
		if(Alpha<-180)
			Alpha+=360;
		else if(Alpha>180)
			Alpha-=360;

		CA=cos((float)Alpha/180*M_PI);
		SA=sin((float)Alpha/180*M_PI);

		Beta=B0-((My0-Y)-(My0-Y)/360*360)/2;
		if(Beta<-180)
			Beta+=360;
		else if(Beta>180)
			Beta-=360;

		CB=cos((float)Beta/180*M_PI);
		SB=sin((float)Beta/180*M_PI);

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
	if(Shift.Contains(ssRight)&&(NScene!=0)&&((Mx0!=X)||(My0!=Y))){
		ShiftX=Sx0-(Mx0-X)*ViewPoint/Screen;
		ShiftY=Sy0+(My0-Y)*ViewPoint/Screen;

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormMouseWheel(TObject *Sender,
      TShiftState Shift, int WheelDelta, TPoint &MousePos, bool &Handled)
{
	if(NScene!=0){
		if(Shift.Contains(ssCtrl)){
			if(WheelDelta>0)
				Screen*=1.1;
			else
				Screen/=1.1;

			MkBallImageList();

			if(!AnimeTimer->Enabled)
				Draw(false);
		}
		else{
			AnimeTimer->Enabled=false;

			Scene+=((WheelDelta<0)-(WheelDelta>0))*Step;

			if(Scene<0)
				Scene=0;
			if(Scene>NScene-1)
				Scene=NScene-1;

			Draw(true);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormDblClick(TObject *Sender)
{
	if(NScene!=0)
		AnimeTimer->Enabled=!AnimeTimer->Enabled;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormKeyDown(TObject *Sender, WORD &Key,
	TShiftState Shift)
{
	if((Key==VK_RETURN)&&(NScene!=0)){
		if(!AnimeTimer->Enabled)
			Draw(false);
		else
			AnimeTimer->Enabled=false;
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormKeyPress(TObject *Sender, char &Key)
{
	if(NScene!=0){
		switch(Key){
			case 'd':
				SaveGRAMenuClick(Sender);
				break;
			case ':':
			case '*':
				ChangeStepMenuClick(Sender);
				break;
			case '+':
				ZoomInMenuClick(Sender);
				break;
			case '[':
			case ']':
				FramedMenuClick(Sender);
				break;
			case '-':
				ZoomOutMenuClick(Sender);
				break;
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormPaint(TObject *Sender)
{
	Canvas->Draw(0,0,ScreenBitmap);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
	AnimeTimer->Enabled=false;
	delete BallBitmap;
	delete ScreenBitmap;
	delete[] Atom;
	delete[] Bond;
	delete[] Distance;
	delete[] CompList;
	delete[] AtomSize;
	delete[] AtomList;
	delete[] BallSize;
	delete[] DispMol;
	delete[] Numbered;
	fclose(fp);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OpenMenuClick(TObject *Sender)
{
	if(OpenDialog->Execute()){
		delete[] Atom;
		delete[] Bond;
		delete[] Distance;
		delete[] CompList;
		delete[] AtomSize;
		delete[] AtomList;
		delete[] DispMol;
		delete[] Numbered;

		Refresh();
		FileOpen();
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::CopyBMPMenuClick(TObject *Sender)
{
	Clipboard()->Assign(ScreenBitmap);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SaveBMPMenuClick(TObject *Sender)
{
	AnimeTimer->Enabled=false;

	SaveDialog->Title="Save as BMP";
	SaveDialog->DefaultExt="bmp";
	SaveDialog->FilterIndex=1;
	SaveDialog->FileName="pv.bmp";

	if(SaveDialog->Execute()){
		ScreenBitmap->SaveToFile(SaveDialog->FileName);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::CopyEMFMenuClick(TObject *Sender)
{
	FILE *fc;

	int moltype;
	int red[16],green[16],blue[16];
	Point Pbuf,Pbuf2;

	float time;
	AnsiString temp;
	int i,ii,im,jm,ix0,iy0,ix,iy,y,attr;

	AnimeTimer->Enabled=false;

	if(MolType==0)
		moltype=NMol;
	else
		moltype=MolType;

	Metafile=new TMetafile;
	Metafile->Width=ClientWidth;
	Metafile->Height=ClientHeight;

	MetaCanvas=new TMetafileCanvas(Metafile,0);
	MetaCanvas->Pen->Color=clBlack;
	MetaCanvas->Brush->Style=bsSolid;

	if(Application->MessageBox("Color balls?","Copy EMF",MB_YESNO+MB_ICONQUESTION)==IDYES){
		fc=fopen((ExtractFilePath(OpenDialog->FileName)+"ball.dat").c_str(),"r");
		if(fc==NULL){
			fclose(fc);
			fc=fopen((ExtractFilePath(Application->ExeName)+"ball.dat").c_str(),"r");
		}
		if(fc!=NULL){
			for(i=0;i<16;i++)
				fscanf(fc,"%d,%d,%d\n",&red[i],&green[i],&blue[i]);
		}
		else{
			Application->MessageBox("\"ball.dat\" is not found!","PVWin",MB_OK+MB_ICONWARNING);
			for(i=0;i<16;i++){
				red[i]=255;
				green[i]=255;
				blue[i]=255;
			}
		}
		fclose(fc);
	}
	else{
		for(i=0;i<16;i++){
			red[i]=255;
			green[i]=255;
			blue[i]=255;
		}
	}

	if(FramedMenu->Checked){
		MetaCanvas->Pen->Style=psDot;
		for(i=0;i<6;i++){
			if(FBack[i]){
				im=Frame[i][0];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix0,iy0);
				MetaCanvas->MoveTo(ix0,iy0);

				im=Frame[i][1];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				MetaCanvas->LineTo(ix,iy);

				im=Frame[i][3];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				MetaCanvas->LineTo(ix,iy);

				im=Frame[i][2];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				MetaCanvas->LineTo(ix,iy);

				MetaCanvas->LineTo(ix0,iy0);
			}
		}
	}

	MetaCanvas->Pen->Style=psSolid;
	for(i=0;i<NMol+NBond;i++){
		im=CompList[i];
		if(im<NMol){
			attr=Atom[im].Attr;
			if((!HideMolMenu->Checked)&&(DispMol[im])&&(DispColor[attr])){
				Pbuf.x=Atom[im].x;
				Pbuf.y=Atom[im].y;
				Pbuf.z=Atom[im].z;

				y=(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB);

				if(!NotFixSliceMenu->Checked||((y>=-NFThickness)&&(y<=NFThickness))){
					ii=AtomList[im%moltype];

					Project((int)(Pbuf.x*CA+Pbuf.y*SA),y,
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);

					MetaCanvas->Brush->Color=(TColor)(red[attr]+256*green[attr]+256*256*blue[attr]);
					MetaCanvas->Ellipse(ix-BallSize[ii]/2-1,iy-BallSize[ii]/2-1,
					                    ix+BallSize[ii]/2+1,iy+BallSize[ii]/2+1);
				}
			}
		}

		else{
			ii=CompList[i]-NMol;
			attr=Bond[ii].Attr;
			if((!HideBondMenu->Checked)&&(attr!=0xff)&&(DispBColor[attr/16])){
				if(ThickBondMenu->Checked)
					MetaCanvas->Pen->Width=-Screen/ViewPoint*(attr-attr/16*16+1)/50;

				im=Bond[ii].p1-1;
				jm=Bond[ii].p2-1;

				Pbuf.x=Atom[im].x;
				Pbuf.y=Atom[im].y;
				Pbuf.z=Atom[im].z;
				Pbuf2.x=Atom[jm].x;
				Pbuf2.y=Atom[jm].y;
				Pbuf2.z=Atom[jm].z;

				if((abs(Pbuf.x-Pbuf2.x)<(float)Vlx/2)
				 &&(abs(Pbuf.y-Pbuf2.y)<(float)Vly/2)
				 &&(abs(Pbuf.z-Pbuf2.z)<(float)Vlz/2)){
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					MetaCanvas->MoveTo(ix,iy);

					Project((int)(Pbuf2.x*CA+Pbuf2.y*SA),
					        (int)((-Pbuf2.x*SA+Pbuf2.y*CA)*CB-Pbuf2.z*SB),
					        (int)((-Pbuf2.x*SA+Pbuf2.y*CA)*SB+Pbuf2.z*CB),ix,iy);
					MetaCanvas->LineTo(ix,iy);
				}
				MetaCanvas->Pen->Width=1;
			}
		}
	}

	if(FramedMenu->Checked){
		for(i=0;i<6;i++){
			if(!FBack[i]){
				im=Frame[i][0];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix0,iy0);
				MetaCanvas->MoveTo(ix0,iy0);

				im=Frame[i][1];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				MetaCanvas->LineTo(ix,iy);

				im=Frame[i][3];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				MetaCanvas->LineTo(ix,iy);

				im=Frame[i][2];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				MetaCanvas->LineTo(ix,iy);

				MetaCanvas->LineTo(ix0,iy0);
			}
		}
	}

	time=Time0+DT*Scene;
	if(DT<0.01)
		temp=FloatToStrF(time,ffFixed,15,3)+"ps";
	else if(DT<0.1)
		temp=FloatToStrF(time,ffFixed,15,2)+"ps";
	else if(DT<1)
		temp=FloatToStrF(time,ffFixed,15,1)+"ps";
	else if(DT<100)
		temp=FloatToStrF(time,ffFixed,15,0)+"ps";
	else if(DT<1000)
		temp=FloatToStrF(time/1000,ffFixed,15,1)+"ns";
	else
		temp=FloatToStrF(time/1000,ffFixed,15,0)+"ns";

	if(DispTimeMenu->Checked){
		MetaCanvas->Brush->Style=bsClear;
		MetaCanvas->Font->Size=Canvas->Font->Size;
		MetaCanvas->TextOut(TimeX-MetaCanvas->TextWidth(temp),TimeY,temp);
		MetaCanvas->Font->Size=12;
	}

	delete MetaCanvas;
	Clipboard()->Assign(Metafile);
	if(Application->MessageBox("Save to file?","Copy EMF",
			MB_YESNO+MB_ICONQUESTION)==IDYES){
		SaveDialog->Title="Save as EMF";
		SaveDialog->DefaultExt="emf";
		SaveDialog->FilterIndex=2;
		SaveDialog->FileName="pv.emf";
		if(SaveDialog->Execute())
			Metafile->SaveToFile(SaveDialog->FileName);
	}
	delete Metafile;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SaveGRAMenuClick(TObject *Sender)
{
	FILE *fg,*fc;

	int moltype,mag;
	int red[16],green[16],blue[16];
	Point Pbuf,Pbuf2;

	int i,ii,im,jm,ix0,iy0,ix,iy,y,ir,attr;

	AnimeTimer->Enabled=false;

	if(MolType==0)
		moltype=NMol;
	else
		moltype=MolType;

	SaveDialog->Title="Save as GRA";
	SaveDialog->DefaultExt="gra";
	SaveDialog->FilterIndex=3;
	SaveDialog->FileName="pv.gra";

	if(SaveDialog->Execute()){
		mag=min(21000/ClientWidth,29700/ClientHeight);

		if(Application->MessageBox("Color balls?","Save GRA",
				MB_YESNO+MB_ICONQUESTION)==IDYES){
			fc=fopen((ExtractFilePath(OpenDialog->FileName)+"ball.dat").c_str(),"r");
			if(fc==NULL){
				fclose(fc);
				fc=fopen((ExtractFilePath(Application->ExeName)+"ball.dat").c_str(),"r");
			}
			if(fc!=NULL){
				for(i=0;i<16;i++)
					fscanf(fc,"%d,%d,%d\n",&red[i],&green[i],&blue[i]);
			}
			else{
				Application->MessageBox("\"ball.dat\" is not found!","PVWin",MB_OK+MB_ICONWARNING);
				for(i=0;i<16;i++){
					red[i]=255;
					green[i]=255;
					blue[i]=255;
				}
			}
			fclose(fc);
		}
		else{
			for(i=0;i<16;i++){
				red[i]=255;
				green[i]=255;
				blue[i]=255;
			}
		}

		fg=fopen(SaveDialog->FileName.c_str(),"w");

		fprintf(fg,"%%Ngraph GRAF\n");
		fprintf(fg,"%%Creator: PVWin.exe\n");
		fprintf(fg,"I,5,0,4000,21000,29700,10000\n");
		fprintf(fg,"V,5,0,4000,21000,29700,1\n");

		fprintf(fg,"G,3,0,0,0\n");
		fprintf(fg,"A,7,2,20,0,0,1000,100,200\n");
		if(FramedMenu->Checked){
			for(i=0;i<6;i++){
				if(FBack[i]){
					im=Frame[i][0];
					Pbuf.x=FPoint[im].x;
					Pbuf.y=FPoint[im].y;
					Pbuf.z=FPoint[im].z;
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix0,iy0);
					fprintf(fg,"M,2,%d,%d\n",ix0*mag,iy0*mag);

					im=Frame[i][1];
					Pbuf.x=FPoint[im].x;
					Pbuf.y=FPoint[im].y;
					Pbuf.z=FPoint[im].z;
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					fprintf(fg,"T,2,%d,%d\n",ix*mag,iy*mag);

					im=Frame[i][3];
					Pbuf.x=FPoint[im].x;
					Pbuf.y=FPoint[im].y;
					Pbuf.z=FPoint[im].z;
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					fprintf(fg,"T,2,%d,%d\n",ix*mag,iy*mag);

					im=Frame[i][2];
					Pbuf.x=FPoint[im].x;
					Pbuf.y=FPoint[im].y;
					Pbuf.z=FPoint[im].z;
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					fprintf(fg,"T,2,%d,%d\n",ix*mag,iy*mag);

					fprintf(fg,"T,2,%d,%d\n",ix0*mag,iy0*mag);
				}
			}
		}

		fprintf(fg,"A,5,0,20,0,0,1000\n");
		for(i=0;i<NMol+NBond;i++){
			im=CompList[i];
			if(im<NMol){
				attr=Atom[im].Attr;
				if((!HideMolMenu->Checked)&&(DispMol[im])&&(DispColor[attr])){
					Pbuf.x=Atom[im].x;
					Pbuf.y=Atom[im].y;
					Pbuf.z=Atom[im].z;

					y=(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB);

					if(!NotFixSliceMenu->Checked||((y>=-NFThickness)&&(y<=NFThickness))){
						Project((int)(Pbuf.x*CA+Pbuf.y*SA),
						        y,
						        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);

						ir=BallSize[AtomList[im%moltype]]/2;
						if((ix+ir>=0)&&(ix-ir<=ClientWidth)&&(iy+ir>=0)&&(iy-ir<=ClientHeight)){
							fprintf(fg,"G,3,%d,%d,%d\n",red[attr],green[attr],blue[attr]);
							fprintf(fg,"C,7,%d,%d,%d,%d,0,36000,1\n",ix*mag,iy*mag,ir*mag,ir*mag);
							fprintf(fg,"G,3,0,0,0\n");
							fprintf(fg,"C,7,%d,%d,%d,%d,0,36000,0\n",ix*mag,iy*mag,ir*mag,ir*mag);
						}
					}
				}
			}

			else{
				ii=CompList[i]-NMol;
				attr=Bond[ii].Attr;
				if((!HideBondMenu->Checked)&&(attr!=0xff)&&(DispBColor[attr/16])){
					im=Bond[CompList[i]-NMol].p1-1;
					jm=Bond[CompList[i]-NMol].p2-1;

					Pbuf.x=Atom[im].x;
					Pbuf.y=Atom[im].y;
					Pbuf.z=Atom[im].z;
					Pbuf2.x=Atom[jm].x;
					Pbuf2.y=Atom[jm].y;
					Pbuf2.z=Atom[jm].z;

					if((abs(Pbuf.x-Pbuf2.x)<(float)Vlx/2)
					 &&(abs(Pbuf.y-Pbuf2.y)<(float)Vly/2)
					 &&(abs(Pbuf.z-Pbuf2.z)<(float)Vlz/2)){
						Project((int)(Pbuf.x*CA+Pbuf.y*SA),
								(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
								(int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix0,iy0);
						Project((int)(Pbuf2.x*CA+Pbuf2.y*SA),
								(int)((-Pbuf2.x*SA+Pbuf2.y*CA)*CB-Pbuf2.z*SB),
								(int)((-Pbuf2.x*SA+Pbuf2.y*CA)*SB+Pbuf2.z*CB),ix,iy);

						if(((ix0>=0)&&(ix0<=ClientWidth)&&(iy0>=0)&&(iy0<=ClientHeight))||
								((ix>=0)&&(ix<=ClientWidth)&&(iy>=0)&&(iy<=ClientHeight))){
							fprintf(fg,"M,2,%d,%d\n",ix0*mag,iy0*mag);
							fprintf(fg,"T,2,%d,%d\n",ix*mag,iy*mag);
						}
					}
				}
			}
		}

		if(FramedMenu->Checked){
			for(i=0;i<6;i++){
				if(!FBack[i]){
					im=Frame[i][0];
					Pbuf.x=FPoint[im].x;
					Pbuf.y=FPoint[im].y;
					Pbuf.z=FPoint[im].z;
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
							(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
							(int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix0,iy0);
					fprintf(fg,"M,2,%d,%d\n",ix0*mag,iy0*mag);

					im=Frame[i][1];
					Pbuf.x=FPoint[im].x;
					Pbuf.y=FPoint[im].y;
					Pbuf.z=FPoint[im].z;
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
							(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
							(int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					fprintf(fg,"T,2,%d,%d\n",ix*mag,iy*mag);

					im=Frame[i][3];
					Pbuf.x=FPoint[im].x;
					Pbuf.y=FPoint[im].y;
					Pbuf.z=FPoint[im].z;
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
							(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
							(int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					fprintf(fg,"T,2,%d,%d\n",ix*mag,iy*mag);

					im=Frame[i][2];
					Pbuf.x=FPoint[im].x;
					Pbuf.y=FPoint[im].y;
					Pbuf.z=FPoint[im].z;
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
							(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
							(int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					fprintf(fg,"T,2,%d,%d\n",ix*mag,iy*mag);

					fprintf(fg,"T,2,%d,%d\n",ix0*mag,iy0*mag);
				}
			}
		}
		fprintf(fg,"E,0\n");
		fclose(fg);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SaveAnimeMenuClick(TObject *Sender)
{
	AnsiString temp;

	if(SaveAnimeMenu->Checked){
		SaveAnimeMenu->Checked=false;

		MainForm->Caption=OpenDialog->FileName+"   "
											+Scene+"/"+(NScene-1)+"   "
											+FloatToStrF(Time0+DT*Scene,ffFixed,15,2)+"ps";

		OpenMenu->Enabled=true;
		SaveBMPMenu->Enabled=true;
		CopyEMFMenu->Enabled=true;
		SaveGRAMenu->Enabled=true;
	}
	else{
		EditForm->Caption="Directry";
		EditForm->Edit->Text=AnimeDir;

		if(EditForm->ShowModal()==1){
			AnimeDir=EditForm->Edit->Text;
			mkdir(AnimeDir.c_str());

			EditForm->Caption="Start File Number";
			EditForm->Edit->Text="0";

			if(EditForm->ShowModal()==1){
				try{
					AnimeFrame=StrToInt(EditForm->Edit->Text);
				}
				catch(...){
					Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
					return;
				}

				if(AnimeFrame<0)
					AnimeFrame=0;

				temp=AnimeFrame;
				while(temp.Length()<4)
					temp="0"+temp;
				ScreenBitmap->SaveToFile(AnimeDir+"\\"+temp+".bmp");

				AnimeFrame++;

				SaveAnimeMenu->Checked=true;

				OpenMenu->Enabled=false;
				SaveBMPMenu->Enabled=false;
				CopyEMFMenu->Enabled=false;
				SaveGRAMenu->Enabled=false;

				MainForm->Caption=MainForm->Caption+"   "+temp+".bmp";
			}
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SaveCFGMenuClick(TObject *Sender)
{
	FILE *fc;
	AnsiString fcname,value;
	int i;

	fcname=OpenDialog->FileName;
	fcname.SetLength(fcname.LastDelimiter("."));
	fc=fopen((fcname+"cfg").c_str(),"w");

	fprintf(fc,"top    : %d\n",Top);
	fprintf(fc,"left   : %d\n",Left);
	fprintf(fc,"width  : %d\n",ClientWidth);
	fprintf(fc,"height : %d\n",ClientHeight);
	fprintf(fc,"\n");
	fprintf(fc,"foreground color(R,G,B) : %d,%d,%d\n",(int)FGColor%256,(int)FGColor%(256*256)/256,(int)FGColor/(256*256));
	fprintf(fc,"background color(R,G,B) : %d,%d,%d\n",(int)BGColor%256,(int)BGColor%(256*256)/256,(int)BGColor/(256*256));
	fprintf(fc,"\n");
	fprintf(fc,"animation(off=0) : %d\n",AnimeTimer->Enabled);
	fprintf(fc,"anime interval   : %d\n",AnimeTimer->Interval);
	fprintf(fc,"\n");
	fprintf(fc,"scene : %d\n",Scene);
	fprintf(fc,"step  : %d\n",Step);
	fprintf(fc,"\n");
	fprintf(fc,"expand speed x : %f\n",DX);
	fprintf(fc,"expand speed y : %f\n",DY);
	fprintf(fc,"expand speed z : %f\n",DZ);
	fprintf(fc,"\n");
	fprintf(fc,"expand rate x : %f\n",RX);
	fprintf(fc,"expand rate y : %f\n",RY);
	fprintf(fc,"expand rate z : %f\n",RZ);
	fprintf(fc,"\n");
	fprintf(fc,"magnification : %f\n",-Screen/ViewPoint/5.0);
	fprintf(fc,"ball mag      : %f\n",BallMag);
	fprintf(fc,"\n");
	fprintf(fc,"alpha : %d\n",Alpha);
	fprintf(fc,"beta  : %d\n",Beta);
	fprintf(fc,"\n");
	fprintf(fc,"shift right : %d\n",ShiftX);
	fprintf(fc,"shift up    : %d\n",ShiftY);
	fprintf(fc,"\n");
	fprintf(fc,"x center : %.2f\n",CShiftX/100.0);
	fprintf(fc,"y center : %.2f\n",CShiftY/100.0);
	fprintf(fc,"z center : %.2f\n",CShiftZ/100.0);
	fprintf(fc,"\n");
	fprintf(fc,"fix slice(off=0) : %d\n",FixSliceMenu->Checked);
	fprintf(fc,"fix thickness    : %d\n",FThickness/50);
	fprintf(fc,"not fix slice(off=0) : %d\n",NotFixSliceMenu->Checked);
	fprintf(fc,"not fix thickness    : %d\n",NFThickness/50);
	fprintf(fc,"\n");
	fprintf(fc,"frame(off=0)       : %d\n",FramedMenu->Checked);
	fprintf(fc,"perspective(off=0) : %d\n",PerspectiveMenu->Checked);
	fprintf(fc,"\n");
	fprintf(fc,"number(off=0) : %d\n",NumberedMenu->Checked);
	fprintf(fc,"\n");
	fprintf(fc,"hide mol(off=0)  : %d\n",HideMolMenu->Checked);
	fprintf(fc,"hide mol color   : ");
		value="";
		for(i=0;i<16;i++){
			if(!DispColor[i])
				value+=IntToStr(i)+",";
		}
		fprintf(fc,"%s\n",value.SetLength(value.Length()-1).c_str());;
	fprintf(fc,"\n");
	fprintf(fc,"hide bond(off=0) : %d\n",HideBondMenu->Checked);
	fprintf(fc,"hide bond color   : ");
		value="";
		for(i=0;i<16;i++){
			if(!DispBColor[i])
				value+=IntToStr(i)+",";
		}
		fprintf(fc,"%s\n",value.SetLength(value.Length()-1).c_str());;
	fprintf(fc,"\n");
	fprintf(fc,"time(off=0)   : %d\n",DispTimeMenu->Checked);
	fprintf(fc,"time font size  : %d\n",Canvas->Font->Size);
	fprintf(fc,"time position x : %d\n",TimeX);
	fprintf(fc,"time position y : %d\n",TimeY);
	fprintf(fc,"\n");
	fprintf(fc,"thick bond(off=0)  : %d\n",ThickBondMenu->Checked);
	fclose(fc);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ExitMenuClick(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::StepMenuClick(TObject *Sender)
{
	AnimeTimer->Enabled=false;

	Scene+=Step;

	if(Scene<0)
		Scene=0;
	if(Scene>NScene-1)
		Scene=NScene-1;

	Draw(true);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::BackStepMenuClick(TObject *Sender)
{
	AnimeTimer->Enabled=false;

	Scene-=Step;

	if(Scene<0)
		Scene=0;
	if(Scene>NScene-1)
		Scene=NScene-1;

	Draw(true);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::GotoMenuClick(TObject *Sender)
{
	AnimeTimer->Enabled=false;

	EditForm->Caption="Go to";
	EditForm->Edit->Text=NScene-1;

	if(EditForm->ShowModal()==1){
		try{
			Scene=StrToInt(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if(Scene<0)
			Scene=0;
		else if(Scene>NScene-1)
			Scene=NScene-1;

		Draw(true);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AnimateMenuClick(TObject *Sender)
{
	AnimeTimer->Enabled=true;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AnimeIntervalClick(TObject *Sender)
{
	EditForm->Caption="Anime Interval";
	EditForm->Edit->Text=AnimeTimer->Interval;

	if(EditForm->ShowModal()==1){
		try{
			AnimeTimer->Interval=StrToInt(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if(AnimeTimer->Interval<1)
			AnimeTimer->Interval=1;
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ChangeStepMenuClick(TObject *Sender)
{
	EditForm->Caption="Change Step";
	EditForm->Edit->Text=Step;

	if(EditForm->ShowModal()==1){
		try{
			Step=StrToInt(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ExpandSpeedMenuClick(TObject *Sender)
{
	EditForm->Caption="Expand Speed X";
	EditForm->Edit->Text=DX;

	if(EditForm->ShowModal()==1){
		try{
			DX=StrToFloat(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		EditForm->Caption="Expand Speed Y";
		EditForm->Edit->Text=DY;

		if(EditForm->ShowModal()==1){
			try{
				DY=StrToFloat(EditForm->Edit->Text);
			}
			catch(...){
				Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}

			EditForm->Caption="Expand Speed Z";
			EditForm->Edit->Text=DZ;

			if(EditForm->ShowModal()==1){
				try{
					DZ=StrToFloat(EditForm->Edit->Text);
				}
				catch(...){
					Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
					return;
				}

				if(!AnimeTimer->Enabled)
					Draw(false);
			}
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ExpandRateMenuClick(TObject *Sender)
{
	EditForm->Caption="Expand Rate X";
	EditForm->Edit->Text=RX;

	if(EditForm->ShowModal()==1){
		try{
			RX=StrToFloat(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		EditForm->Caption="Expand Rate Y";
		EditForm->Edit->Text=RY;

		if(EditForm->ShowModal()==1){
			try{
				RY=StrToFloat(EditForm->Edit->Text);
			}
			catch(...){
				Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}

			EditForm->Caption="Expand Rate Z";
			EditForm->Edit->Text=RZ;

			if(EditForm->ShowModal()==1){
				try{
					RZ=StrToFloat(EditForm->Edit->Text);
				}
				catch(...){
					Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
					return;
				}

				if(!AnimeTimer->Enabled)
					Draw(false);
			}
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SetXCenterMenuClick(TObject *Sender)
{
	EditForm->Caption="X Center";
	EditForm->Edit->Text=CShiftX/100.0;

	if(EditForm->ShowModal()==1){
		try{
			CShiftX=(int)(StrToFloat(EditForm->Edit->Text)*100);
		}
		catch(...){
			Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if(!AnimeTimer->Enabled)
			Draw(true);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SetYCenterMenuClick(TObject *Sender)
{
	EditForm->Caption="Y Center";
	EditForm->Edit->Text=CShiftY/100.0;

	if(EditForm->ShowModal()==1){
		try{
			CShiftY=(int)(StrToFloat(EditForm->Edit->Text)*100);
		}
		catch(...){
			Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if(!AnimeTimer->Enabled)
			Draw(true);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SetZCenterMenuClick(TObject *Sender)
{
	EditForm->Caption="Z Center";
	EditForm->Edit->Text=CShiftZ/100;

	if(EditForm->ShowModal()==1){
		try{
			CShiftZ=(int)(StrToFloat(EditForm->Edit->Text)*100);
		}
		catch(...){
			Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if(!AnimeTimer->Enabled)
			Draw(true);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SetCenteratMenuClick(TObject *Sender)
{
	int moltype;
	int i;

	if(MolType==0)
		moltype=1;
	else
		moltype=MolType;

	EditForm->Caption="Molecule Number";
	EditForm->Edit->Clear();

	if(EditForm->ShowModal()==1){
		try{
			i=(StrToInt(EditForm->Edit->Text)-1)*moltype;
		}
		catch(...){
			Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if((i>=0)&&(i<NMol)){
			CShiftX-=Atom[i].x;
			CShiftY-=Atom[i].y;
			CShiftZ-=Atom[i].z;
			ShiftX=0;
			ShiftY=0;

			if(!AnimeTimer->Enabled)
				Draw(true);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::BallMagMenuClick(TObject *Sender)
{
	EditForm->Caption="Ball Magnification Rate";
	EditForm->Edit->Text=BallMag;

	if(EditForm->ShowModal()==1){
		try{
			BallMag=StrToFloat(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if(BallMag<0.0)
			BallMag=0.0;

		MkBallImageList();

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FramedMenuClick(TObject *Sender)
{
	FramedMenu->Checked=!FramedMenu->Checked;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::PerspectiveMenuClick(TObject *Sender)
{
	PerspectiveMenu->Checked=!PerspectiveMenu->Checked;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::NumberedMenuClick(TObject *Sender)
{
	NumberedMenu->Checked=!NumberedMenu->Checked;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::PickMolMenuClick(TObject *Sender)
{
	int moltype;
	int i,n0,n1;
	AnsiString temp1,temp2;

	if(MolType==0)
		moltype=1;
	else
		moltype=MolType;

	EditForm->Caption="Molecular Number";
	EditForm->Edit->Clear();

	if(EditForm->ShowModal()==1){
		temp1=EditForm->Edit->Text;
		while(temp1.Pos(",")!=0){
			temp2=temp1.SubString(1,temp1.Pos(",")-1);
			temp1.Delete(1,temp1.Pos(","));
			if(temp2.Pos("-")!=0){
				try{
					n0=StrToInt((temp2.SubString(1,temp2.Pos("-")-1)));
				}
				catch(...){
					Application->MessageBox("Input list of integers as \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
					return;
				}

				temp2.Delete(1,temp2.Pos("-"));

				try{
					n1=StrToInt(temp2);
				}
				catch(...){
					Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
					return;
				}

				if(n0<1)
					n0=1;
				if(n1>NMol/moltype)
					n1=NMol/moltype;
				for(i=n0-1;i<n1;i++)
					Numbered[i]=!Numbered[i];
			}
			else{
				try{
					i=StrToInt(temp2)-1;
				}
				catch(...){
					Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
					return;
				}

				if((i>=0)&&(i<NMol/moltype))
					Numbered[i]=!Numbered[i];
			}
		}

		if(temp1.Pos("-")!=0){
			try{
				n0=StrToInt((temp1.SubString(1,temp1.Pos("-")-1)));
			}
			catch(...){
				Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}

			temp1.Delete(1,temp1.Pos("-"));

			try{
				n1=StrToInt(temp1);
			}
			catch(...){
				Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}

			if(n0<1)
				n0=1;
			if(n1>NMol/moltype)
				n1=NMol/moltype;
			for(i=n0-1;i<n1;i++)
				Numbered[i]=!Numbered[i];
		}
		else{
			try{
				i=StrToInt(temp1)-1;
			}
			catch(...){
				Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}

			if((i>=0)&&(i<NMol/moltype))
				Numbered[i]=!Numbered[i];
		}

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FixSliceMenuClick(TObject *Sender)
{
	int i;

	if(FixSliceMenu->Checked){
		FixSliceMenu->Checked=false;
		FixSliceMenu->Caption="Slice (Fix) ...";

		for(i=0;i<NMol;i++)
			DispMol[i]=true;

		if(!AnimeTimer->Enabled)
			Draw(false);
	}

	else{
		EditForm->Caption="Slice Thickness";
		EditForm->Edit->Text=FThickness/50;

		if(EditForm->ShowModal()==1){
			FSliced=true;
			FixSliceMenu->Checked=true;
			FixSliceMenu->Caption="Sliced (Fix)";

			try{
				FThickness=StrToInt(EditForm->Edit->Text)*50;
			}
			catch(...){
				Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
				FixSliceMenu->Checked=false;
				FixSliceMenu->Caption="Slice (Fix) ...";
				return;
			}

			if(!AnimeTimer->Enabled)
			Draw(false);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::NotFixSliceMenuClick(TObject *Sender)
{
	if(NotFixSliceMenu->Checked){
		NotFixSliceMenu->Checked=false;
		NotFixSliceMenu->Caption="Slice (Not Fix) ...";

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
	else{
		EditForm->Caption="Slice Thickness";
		EditForm->Edit->Text=NFThickness/50;

		if(EditForm->ShowModal()==1){
			NotFixSliceMenu->Checked=true;
			NotFixSliceMenu->Caption="Sliced (Not Fix)";

			try{
				NFThickness=StrToInt(EditForm->Edit->Text)*50;
			}
			catch(...){
				Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
				NotFixSliceMenu->Checked=false;
				NotFixSliceMenu->Caption="Slice (Not Fix) ...";
				return;
			}

			if(!AnimeTimer->Enabled)
				Draw(false);
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMolMenuClick(TObject *Sender)
{
	HideMolMenu->Checked=!HideMolMenu->Checked;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMolColorMenuClick(TObject *Sender)
{
	int i;

	EditForm->Caption="Hide Color Number";
	EditForm->Edit->Clear();

	if(EditForm->ShowModal()==1){
		ReadColorList(DispColor,EditForm->Edit->Text,true);
		for(i=0;i<16;i++)
			PopupMenu->Items->Items[i]->Checked=!DispColor[i];

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideBondMenuClick(TObject *Sender)
{
	HideBondMenu->Checked=!HideBondMenu->Checked;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideBondColorMenuClick(TObject *Sender)
{
	EditForm->Caption="Hide Color Number";
	EditForm->Edit->Clear();

	if(EditForm->ShowModal()==1){
		ReadColorList(DispBColor,EditForm->Edit->Text,true);

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DispTimeMenuClick(TObject *Sender)
{
	DispTimeMenu->Checked=!DispTimeMenu->Checked;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ChangeTimeTextMenuClick(TObject *Sender)
{
	float time;
	AnsiString temp;

	EditForm->Caption="Size";
	EditForm->Edit->Text=Canvas->Font->Size;
	if(EditForm->ShowModal()==1){
		try{
			Canvas->Font->Size=StrToInt(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		time=Time0+DT*Scene;
		if(DT<0.01)
			temp=FloatToStrF(time,ffFixed,15,3)+"ps";
		else if(DT<0.1)
			temp=FloatToStrF(time,ffFixed,15,2)+"ps";
		else if(DT<1)
			temp=FloatToStrF(time,ffFixed,15,1)+"ps";
		else if(DT<100)
			temp=FloatToStrF(time,ffFixed,15,0)+"ps";
		else if(DT<1000)
			temp=FloatToStrF(time/1000,ffFixed,15,1)+"ns";
		else
			temp=FloatToStrF(time/1000,ffFixed,15,0)+"ns";

		EditForm->Caption="X Position(TextWidth="+IntToStr(Canvas->TextWidth(temp))+")";
		EditForm->Edit->Text=TimeX-Canvas->TextWidth(temp);
		if(EditForm->ShowModal()==1){
			try{
				TimeX=StrToInt(EditForm->Edit->Text);
				if(EditForm->Edit->Text.Pos("-")!=0)
					TimeX+=ClientWidth;
				else
					TimeX+=Canvas->TextWidth(temp);
			}
			catch(...){
				TimeX=(ClientWidth+Canvas->TextWidth(temp))/2;
			}

			EditForm->Caption="Y Position(TextHeight="+IntToStr(Canvas->TextHeight(temp))+")";
			EditForm->Edit->Text=TimeY;
			if(EditForm->ShowModal()==1){
				try{
					TimeY=StrToInt(EditForm->Edit->Text);
					if(EditForm->Edit->Text.Pos("-")!=0)
						TimeY+=ClientHeight-Canvas->TextHeight(temp);
				}
				catch(...){
					TimeY=(ClientHeight-Canvas->TextHeight(temp))/2;
				}

				if(!AnimeTimer->Enabled&&DispTimeMenu->Checked)
					Draw(false);
			}
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ThickBondMenuClick(TObject *Sender)
{
	ThickBondMenu->Checked=!ThickBondMenu->Checked;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FGColorMenuClick(TObject *Sender)
{
	ColorDialog->Color=FGColor;
	if(ColorDialog->Execute()){
		FGColor=ColorDialog->Color;
		ScreenBitmap->Canvas->Font->Color=FGColor;
		Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::BGColorMenuClick(TObject *Sender)
{
	ColorDialog->Color=BGColor;
	if(ColorDialog->Execute()){
		BGColor=ColorDialog->Color;
		MainForm->Color=BGColor;
		Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ZoomInMenuClick(TObject *Sender)
{
	Screen*=1.1;
	MkBallImageList();

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ZoomOutMenuClick(TObject *Sender)
{
	Screen/=1.1;
	MkBallImageList();

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ZoomToMenuClick(TObject *Sender)
{
	EditForm->Caption="Zoom Magnification Rate";
	EditForm->Edit->Text=-Screen/ViewPoint/5.0;

	if(EditForm->ShowModal()==1){
		try{
			Screen=-ViewPoint*StrToFloat(EditForm->Edit->Text)*5.0;
		}
		catch(...){
			Application->MessageBox("Input only real number!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		MkBallImageList();

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::RightMenuClick(TObject *Sender)
{
	Alpha-=5;
	if(Alpha<-180)
		Alpha+=360;

	CA=cos((float)Alpha/180*M_PI);
	SA=sin((float)Alpha/180*M_PI);

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::LeftMenuClick(TObject *Sender)
{
	Alpha+=5;
	if(Alpha>180)
		Alpha-=360;

	CA=cos((float)Alpha/180*M_PI);
	SA=sin((float)Alpha/180*M_PI);

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::UpMenuClick(TObject *Sender)
{
	Beta-=5;
	if(Beta<-180)
		Beta+=360;

	CB=cos((float)Beta/180*M_PI);
	SB=sin((float)Beta/180*M_PI);

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DownMenuClick(TObject *Sender)
{
	Beta+=5;
	if(Beta>180)
		Beta-=360;

	CB=cos((float)Beta/180*M_PI);
	SB=sin((float)Beta/180*M_PI);

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AngleMenuClick(TObject *Sender)
{
	EditForm->Caption="Alpha";
	EditForm->Edit->Text=Alpha;

	if(EditForm->ShowModal()==1){
		try{
			Alpha=StrToInt(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if(Alpha<-180)
			Alpha+=360;
		else if(Alpha>180)
			Alpha-=360;

		CA=cos((float)Alpha/180*M_PI);
		SA=sin((float)Alpha/180*M_PI);

		EditForm->Caption="Beta";
		EditForm->Edit->Text=Beta;

		if(EditForm->ShowModal()==1){
			try{
				Beta=StrToInt(EditForm->Edit->Text);
			}
			catch(...){
				Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}

			if(Beta<-180)
				Beta+=360;
			else if(Beta>180)
				Beta-=360;

			CB=cos((float)Beta/180*M_PI);
			SB=sin((float)Beta/180*M_PI);
		}

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ShiftRightMenuClick(TObject *Sender)
{
	ShiftX+=1;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ShiftLeftMenuClick(TObject *Sender)
{
	ShiftX-=1;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ShiftUpMenuClick(TObject *Sender)
{
	ShiftY+=1;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ShiftDownMenuClick(TObject *Sender)
{
	ShiftY-=1;

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ShiftMenuClick(TObject *Sender)
{
	EditForm->Caption="Horizontal Direction";
	EditForm->Edit->Text=ShiftX;

	if(EditForm->ShowModal()==1){
		try{
			ShiftX=StrToInt(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		EditForm->Caption="Virtical Direction";
		EditForm->Edit->Text=ShiftY;

		if(EditForm->ShowModal()==1){
			try{
				ShiftY=StrToInt(EditForm->Edit->Text);
			}
			catch(...){
				Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}
		}

		if(!AnimeTimer->Enabled)
			Draw(false);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::WindowSizeMenuClick(TObject *Sender)
{
	EditForm->Caption="Width";
	EditForm->Edit->Text=ClientWidth;

	if(EditForm->ShowModal()==1){
		try{
			ClientWidth=StrToInt(EditForm->Edit->Text);
		}
		catch(...){
			Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		EditForm->Caption="Height";
		EditForm->Edit->Text=ClientHeight;

		if(EditForm->ShowModal()==1){
			try{
				ClientHeight=StrToInt(EditForm->Edit->Text);
			}
			catch(...){
				Application->MessageBox("Input only integer!","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}
		}
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::InformationMenuClick(TObject *Sender)
{
	InfoForm->FileNameText->Caption=OpenDialog->FileName;

	switch(MolType){
		case 0:
			InfoForm->MolTypeText->Caption="0";
			break;
		case 1:
			InfoForm->MolTypeText->Caption="monoatomic";
			break;
		case 2:
			InfoForm->MolTypeText->Caption="diatomic";
			break;
		case 3:
			InfoForm->MolTypeText->Caption="triatomic";
			break;
		default:
			InfoForm->MolTypeText->Caption=MolType+" atoms";
	}

	if(MolType==0)
		InfoForm->MolTotalText->Caption=NMol;
	else
		InfoForm->MolTotalText->Caption=NMol/MolType;

	InfoForm->StepNumberText->Caption=NScene;

	InfoForm->TimeStepText->Caption=FloatToStrF(DT,ffFixed,15,2);

	InfoForm->RegionSizeText->Caption=FloatToStrF(Vlx/100.0,ffFixed,15,2)+" x "
																		+FloatToStrF(Vly/100.0,ffFixed,15,2)+" x "
																		+FloatToStrF(Vlz/100.0,ffFixed,15,2);

	InfoForm->SceneCountText->Caption=Scene;

	InfoForm->TimeText->Caption=FloatToStrF(Time0+DT*Scene,ffFixed,15,2);

	InfoForm->VisibleMolText->Caption=VisibleMol;

	InfoForm->BondText->Caption=VisibleBond;

	InfoForm->ViewAlphaText->Caption=Alpha;

	InfoForm->ViewBetaText->Caption=Beta;

	InfoForm->MagText->Caption=FloatToStrF(-Screen/ViewPoint/5,ffFixed,15,2);

	InfoForm->ShowModal();
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::DistanceMenuClick(TObject *Sender)
{
	int moltype;
	int i1,i2,x,y,z;
	AnsiString temp1,temp2,text;

	if(MolType==0)
		moltype=1;
	else
		moltype=MolType;

	EditForm->Caption="Molecular Numbers";
	EditForm->Edit->Clear();

	text="";
	if(EditForm->ShowModal()==1){
		temp1=EditForm->Edit->Text;
		while(temp1.Pos(",")!=0){
			temp2=temp1.SubString(1,temp1.Pos(",")-1);
			temp1.Delete(1,temp1.Pos(","));
			try{
				i1=(StrToInt(temp2.SubString(1,temp2.Pos("-")-1))-1)*moltype;
				i2=(StrToInt(temp2.Delete(1,temp2.Pos("-")))-1)*moltype;
			}
			catch(...){
				Application->MessageBox("Input integers as \"1-2,1-3\" !","PVWin",MB_OK+MB_ICONSTOP);
				return;
			}

			if((i1<0)||(i1>=NMol)||(i2<0)||(i2>=NMol))
				return;

			x=Atom[i1].x-Atom[i2].x;
			y=Atom[i1].y-Atom[i2].y;
			z=Atom[i1].z-Atom[i2].z;
			text+=IntToStr(i1/moltype+1)+"-"+IntToStr(i2/moltype+1)+": "+FloatToStrF(sqrt(x*x+y*y+z*z)/100,ffFixed,15,2)+"\n";
		}
		try{
			i1=(StrToInt(temp1.SubString(1,temp1.Pos("-")-1))-1)*moltype;
			i2=(StrToInt(temp1.Delete(1,temp1.Pos("-")))-1)*moltype;
		}
		catch(...){
			Application->MessageBox("Input integers as \"1-2,1-3\" !","PVWin",MB_OK+MB_ICONSTOP);
			return;
		}

		if((i1<0)||(i1>=NMol)||(i2<0)||(i2>=NMol))
			return;

		x=Atom[i1].x-Atom[i2].x;
		y=Atom[i1].y-Atom[i2].y;
		z=Atom[i1].z-Atom[i2].z;
		text+=IntToStr(i1/moltype+1)+"-"+IntToStr(i2/moltype+1)+": "+FloatToStrF(sqrt(x*x+y*y+z*z)/100,ffFixed,15,2)+"\n";
		Application->MessageBox(text.c_str(),"Distance",MB_OK);
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol0MenuClick(TObject *Sender)
{
	HideMol0Menu->Checked=!HideMol0Menu->Checked;
	DispColor[0]=!DispColor[0];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol1MenuClick(TObject *Sender)
{
	HideMol1Menu->Checked=!HideMol1Menu->Checked;
	DispColor[1]=!DispColor[1];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol2MenuClick(TObject *Sender)
{
	HideMol2Menu->Checked=!HideMol2Menu->Checked;
	DispColor[2]=!DispColor[2];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol3MenuClick(TObject *Sender)
{
	HideMol3Menu->Checked=!HideMol3Menu->Checked;
	DispColor[3]=!DispColor[3];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol4MenuClick(TObject *Sender)
{
	HideMol4Menu->Checked=!HideMol4Menu->Checked;
	DispColor[4]=!DispColor[4];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol5MenuClick(TObject *Sender)
{
	HideMol5Menu->Checked=!HideMol5Menu->Checked;
	DispColor[5]=!DispColor[5];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol6MenuClick(TObject *Sender)
{
	HideMol6Menu->Checked=!HideMol6Menu->Checked;
	DispColor[6]=!DispColor[6];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol7MenuClick(TObject *Sender)
{
	HideMol7Menu->Checked=!HideMol7Menu->Checked;
	DispColor[7]=!DispColor[7];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol8MenuClick(TObject *Sender)
{
	HideMol8Menu->Checked=!HideMol8Menu->Checked;
	DispColor[8]=!DispColor[8];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol9MenuClick(TObject *Sender)
{
	HideMol9Menu->Checked=!HideMol9Menu->Checked;
	DispColor[9]=!DispColor[9];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol10MenuClick(TObject *Sender)
{
	HideMol10Menu->Checked=!HideMol10Menu->Checked;
	DispColor[10]=!DispColor[10];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol11MenuClick(TObject *Sender)
{
	HideMol11Menu->Checked=!HideMol11Menu->Checked;
	DispColor[11]=!DispColor[11];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol12MenuClick(TObject *Sender)
{
	HideMol12Menu->Checked=!HideMol12Menu->Checked;
	DispColor[12]=!DispColor[12];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol13MenuClick(TObject *Sender)
{
	HideMol13Menu->Checked=!HideMol13Menu->Checked;
	DispColor[13]=!DispColor[13];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol14MenuClick(TObject *Sender)
{
	HideMol14Menu->Checked=!HideMol14Menu->Checked;
	DispColor[14]=!DispColor[14];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::HideMol15MenuClick(TObject *Sender)
{
	HideMol15Menu->Checked=!HideMol15Menu->Checked;
	DispColor[15]=!DispColor[15];

	if(!AnimeTimer->Enabled)
		Draw(false);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::MkMenuImageList(void)
{
	int i,bs0;
	Graphics::TBitmap *Bitmap1,*Bitmap2;

	MenuImageList->Clear();
	MenuImageList->Height=15;
	MenuImageList->Width=MenuImageList->Height;

	Bitmap1=new Graphics::TBitmap;
	Bitmap2=new Graphics::TBitmap;

	bs0=BallBitmap->Height/4;
	Bitmap1->Height=bs0;
	Bitmap1->Width=bs0;

	Bitmap2->Height=MenuImageList->Height;
	Bitmap2->Width=MenuImageList->Width;
	Bitmap2->Canvas->Pen->Color=clBlack;
	Bitmap2->Canvas->Brush->Color=clBlack;

	for(i=0;i<16;i++){
		Bitmap1->Canvas->CopyRect(Rect(0,0,bs0,bs0),BallBitmap->Canvas,
				Rect(i%4*bs0,i/4*bs0,(i%4+1)*bs0,(i/4+1)*bs0));
		Bitmap2->Canvas->StretchDraw(Rect(0,0,15,15),Bitmap1);
		MenuImageList->AddMasked(Bitmap2,clBlack);
	}

	delete Bitmap1;
	delete Bitmap2;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::MkBallImageList(void)
{
	int i,j,bs0;
	Graphics::TBitmap *Bitmap1,*Bitmap2;

	delete[] BallSize;
	BallSize=new int[NAtomSize];

	BallImageList->Clear();
	BallImageList->Height=int(-Screen/ViewPoint*BallMag*AtomSize[0]/2)*2+1;
	BallImageList->Width=BallImageList->Height;

	Bitmap1=new Graphics::TBitmap;
	Bitmap2=new Graphics::TBitmap;

	bs0=BallBitmap->Height/4;
	Bitmap1->Height=bs0;
	Bitmap1->Width=bs0;

	Bitmap2->Height=BallImageList->Height;
	Bitmap2->Width=BallImageList->Width;
	Bitmap2->Canvas->Pen->Color=clBlack;
	Bitmap2->Canvas->Brush->Color=clBlack;

	for(i=0;i<NAtomSize;i++){
		BallSize[i]=int(-Screen/ViewPoint*BallMag*AtomSize[i]/2)*2+1;
		for(j=0;j<16;j++){
			Bitmap1->Canvas->CopyRect(Rect(0,0,bs0,bs0),BallBitmap->Canvas,
					Rect(j%4*bs0,j/4*bs0,(j%4+1)*bs0,(j/4+1)*bs0));
			Bitmap2->Canvas->StretchDraw(Rect(0,0,BallSize[i],BallSize[i]),Bitmap1);
			BallImageList->AddMasked(Bitmap2,clBlack);
		}
		Bitmap2->Canvas->Rectangle(0,0,Bitmap2->Width,Bitmap2->Height);
	}

	delete Bitmap1;
	delete Bitmap2;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FileOpen(void)
{
	char ident[32];
	struct header{
		long moltype,nmol,nbond,ndata;
		double vlx1,vlx2,vly1,vly2,vlz1,vlz2,time0,dt;
	} h;
	struct header16{
		unsigned short moltype,nmol,nbond,ndata;
		double vlx1,vlx2,vly1,vly2,vlz1,vlz2,time0,dt;
	} h16;

	int moltype;
	double *s1,*s2;

	FILE *fc;
	int red[16],green[16],blue[16];
	int i,j,k;
	double a;
	AnsiString filename;

	Application->Title=ExtractFileName(OpenDialog->FileName);

	fp=fopen(OpenDialog->FileName.c_str(),"rb");
	fread(&ident,32*sizeof(char),1,fp);
	if(StrLComp(ident,"PV-01 /Shoji-Maruyama Laboratory",32)==0)
		PV16=true;
	else if(StrLComp(ident,"PV-32 /Shoji-Maruyama Laboratory",32)==0)
		PV16=false;
	else{
		Application->MessageBox("This file is not PV file!","PVWin",MB_OK+MB_ICONSTOP);
		fclose(fp);
		return;
	}

	if(PV16){
		fread(&h16,sizeof(h16),1,fp);
		h.moltype=h16.moltype;
		h.nmol=h16.nmol;
		h.nbond=h16.nbond;
		h.ndata=h16.ndata;
		h.vlx1=h16.vlx1;
		h.vlx2=h16.vlx2;
		h.vly1=h16.vly1;
		h.vly2=h16.vly2;
		h.vlz1=h16.vlz1;
		h.vlz2=h16.vlz2;
		h.time0=h16.time0;
		h.dt=h16.dt;
	}
	else
		fread(&h,sizeof(h),1,fp);

	MolType=h.moltype;

	if(MolType==0)
		NMol=h.nmol;
	else
		NMol=h.nmol*MolType;

	NBond=h.nbond;
	NScene=h.ndata;

	Vlx0=(int)((h.vlx2-h.vlx1)*100);
	Vly0=(int)((h.vly2-h.vly1)*100);
	Vlz0=(int)((h.vlz2-h.vlz1)*100);

	Time0=h.time0;
	DT=h.dt;

	X0=(int)((h.vlx1+h.vlx2)*50);
	Y0=(int)((h.vly1+h.vly2)*50);
	Z0=(int)((h.vlz1+h.vlz2)*50);

	Screen/=ViewPoint;
	ViewPoint=-Vlx0*4;
	if(ViewPoint>-Vly0)
		ViewPoint=-Vly0*4;
	if(ViewPoint>-Vlz0)
		ViewPoint=-Vlz0*4;
	Screen*=ViewPoint;

	if(MolType==0)
		moltype=h.nmol;
	else
		moltype=MolType;

	s1=new double[moltype];
	s2=new double[moltype];
	fread(s1,sizeof(double),moltype,fp);
	s2[0]=s1[0];
	k=1;
	for(i=1;i<moltype;i++){
		for(j=0;j<k;j++){
			if(s1[i]==s2[j])
				break;
			if(j==k-1){
				s2[k]=s1[i];
				k++;
			}
		}
	}
	NAtomSize=k;
	for(i=0;i<NAtomSize-1;i++){
		for(j=i+1;j<NAtomSize;j++){
			if(s2[i]<s2[j]){
				a=s2[i];
				s2[i]=s2[j];
				s2[j]=a;
			}
		}
	}
	AtomSize=new double[NAtomSize];
	AtomList=new int[moltype];
	for(i=0;i<NAtomSize;i++)
		AtomSize[i]=s2[i];
	for(i=0;i<moltype;i++){
		for(j=0;j<NAtomSize;j++){
			if(s1[i]==AtomSize[j])
				AtomList[i]=j;
		}
	}
	delete[] s1;
	delete[] s2;

	if(PV16){
		HeaderSize=32*sizeof(char)+sizeof(h16)+moltype*sizeof(double);
		BlockSize=sizeof(AtomRec16)*NMol+sizeof(BondRec16)*NBond;
	}
	else{
		HeaderSize=32*sizeof(char)+sizeof(h)+moltype*sizeof(double);
		BlockSize=sizeof(AtomRec)*NMol+sizeof(BondRec)*NBond;
	}

	fseek(fp,0,SEEK_END);
	if(ftell(fp)<HeaderSize+NScene*BlockSize)
		NScene=(ftell(fp)-HeaderSize)/BlockSize;

	Atom=new AtomRec[NMol];
	Bond=new BondRec[NBond];
	Distance=new float[NMol+NBond];

	CompList=new int[NMol+NBond];
	for(i=0;i<NMol+NBond;i++)
		CompList[i]=i;

	FPoint[0].x= Vlx0/2;FPoint[0].y= Vly0/2;FPoint[0].z= Vlz0/2;
	FPoint[1].x=-Vlx0/2;FPoint[1].y= Vly0/2;FPoint[1].z= Vlz0/2;
	FPoint[2].x= Vlx0/2;FPoint[2].y=-Vly0/2;FPoint[2].z= Vlz0/2;
	FPoint[3].x=-Vlx0/2;FPoint[3].y=-Vly0/2;FPoint[3].z= Vlz0/2;
	FPoint[4].x= Vlx0/2;FPoint[4].y= Vly0/2;FPoint[4].z=-Vlz0/2;
	FPoint[5].x=-Vlx0/2;FPoint[5].y= Vly0/2;FPoint[5].z=-Vlz0/2;
	FPoint[6].x= Vlx0/2;FPoint[6].y=-Vly0/2;FPoint[6].z=-Vlz0/2;
	FPoint[7].x=-Vlx0/2;FPoint[7].y=-Vly0/2;FPoint[7].z=-Vlz0/2;

	Frame[0][0]=0;Frame[0][1]=1;Frame[0][2]=2;Frame[0][3]=3;
	Frame[1][0]=0;Frame[1][1]=4;Frame[1][2]=1;Frame[1][3]=5;
	Frame[2][0]=0;Frame[2][1]=2;Frame[2][2]=4;Frame[2][3]=6;
	Frame[3][0]=7;Frame[3][1]=5;Frame[3][2]=6;Frame[3][3]=4;
	Frame[4][0]=7;Frame[4][1]=6;Frame[4][2]=3;Frame[4][3]=2;
	Frame[5][0]=7;Frame[5][1]=3;Frame[5][2]=5;Frame[5][3]=1;

	for(i=0;i<16;i++){
		DispColor[i]=true;
		DispBColor[i]=true;
	}

	ReadCFG();

	DispMol=new bool[NMol];
	for(i=0;i<NMol;i++)
		DispMol[i]=true;

	if(MolType==0){
		Numbered=new bool[NMol];
		for(i=0;i<NMol;i++)
			Numbered[i]=false;
	}
	else{
		Numbered=new bool[NMol/MolType];
		for(i=0;i<NMol/MolType;i++)
			Numbered[i]=false;
	}

	SaveAnimeMenu->Checked=false;

	FSliced=FixSliceMenu->Checked;
	if(FixSliceMenu->Checked)
		FixSliceMenu->Caption="Sliced (Fix)";
	else
		FixSliceMenu->Caption="Slice (Fix) ...";

	if(NotFixSliceMenu->Checked)
		NotFixSliceMenu->Caption="Sliced (Not Fix)";
	else
		NotFixSliceMenu->Caption="Slice (Not Fix) ...";

	CopyEMFMenu->Enabled=true;
	SaveGRAMenu->Enabled=true;
	SaveAnimeMenu->Enabled=true;
	SaveCFGMenu->Enabled=true;
	SceneMenu->Enabled=true;
	ViewMenu->Enabled=true;
	CameraMenu->Enabled=true;
	InfoMenu->Enabled=true;
	PopupMenu->AutoPopup=true;

	AnimeDir=ExtractFilePath(OpenDialog->FileName)+"Anime";

	try{
		BallBitmap->LoadFromFile(ExtractFilePath(OpenDialog->FileName)+"ball.bmp");
	}
	catch(...){
		filename=ExtractFilePath(Application->ExeName)+"ball.bmp";
		if(FileExists(filename)){
			try{
				BallBitmap->LoadFromFile(ExtractFilePath(Application->ExeName)+"ball.bmp");
			}
			catch(...){
				Application->MessageBox("\"ball.bmp\" is incorrect!","PVWin",MB_OK+MB_ICONWARNING);
			}
		}
	}

	if(NBond>0){
		fc=fopen((ExtractFilePath(OpenDialog->FileName)+"bondc.dat").c_str(),"r");
		if(fc==NULL){
			fclose(fc);
			fc=fopen((ExtractFilePath(Application->ExeName)+"bondc.dat").c_str(),"r");
		}
		if(fc!=NULL){
			for(i=0;i<16;i++)
				fscanf(fc,"%d,%d,%d\n",&red[i],&green[i],&blue[i]);
		}
		else{
			for(i=0;i<16;i++){
				red[i]=255;
				green[i]=255;
				blue[i]=0;
			}
		}
		for(i=0;i<16;i++){
			BondColor[i]=(TColor)(red[i]+256*green[i]+256*256*blue[i]);
		}
		fclose(fc);
	}

	MkMenuImageList();
	MkBallImageList();
	Draw(true);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ReadCFG(void)
{
	FILE *fc;
	AnsiString fcname,line;
	TStringList *key,*value;
	char linebuf[256];
	int i,r,g,b;

	key=new TStringList;
	value=new TStringList;

	fcname=OpenDialog->FileName;
	fcname.SetLength(fcname.LastDelimiter("."));
	fc=fopen((fcname+"cfg").c_str(),"r");
	if(fc==NULL){
		fclose(fc);
		fc=fopen((ExtractFilePath(Application->ExeName)+"pvwin.cfg").c_str(),"r");
	}

	if(fc!=NULL){
		while(!feof(fc)){
			line=fgets(linebuf,256,fc);
			i=line.AnsiPos(":");
			if(i!=0){
				key->Add(line.SubString(1,i-1).Trim());
				value->Add(line.SubString(i+1,255).Trim());
			}
		}
	}
	fclose(fc);

	if((i=key->IndexOf("top"))>=0){
		try{
			Top=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"top\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
		}
	}
	if((i=key->IndexOf("left"))>=0){
		try{
			Left=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"left\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
		}
	}
	if((i=key->IndexOf("width"))>=0){
		try{
			ClientWidth=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"width\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
		}
	}
	if((i=key->IndexOf("height"))>=0){
		try{
			ClientHeight=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"height\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
		}
	}

	if((i=key->IndexOf("foreground color(R,G,B)"))>=0){
		try{
			sscanf(value->Strings[i].c_str(),"%d,%d,%d",&r,&g,&b);
			FGColor=(TColor)(r+256*g+256*256*b);
			ScreenBitmap->Canvas->Font->Color=FGColor;
			ColorDialog->CustomColors->Add("ColorA="+IntToHex((int)FGColor,6));
		}
		catch(...){
			Application->MessageBox("cfg file is incorect!\n\n\"foreground color(R,G,B)\" must be list of integers.","PVWin",MB_OK+MB_ICONWARNING);
		}
	}
	if((i=key->IndexOf("background color(R,G,B)"))>=0){
		try{
			sscanf(value->Strings[i].c_str(),"%d,%d,%d",&r,&g,&b);
			BGColor=(TColor)(r+256*g+256*256*b);
			MainForm->Color=BGColor;
			ColorDialog->CustomColors->Add("ColorB="+IntToHex((int)BGColor,6));
		}
		catch(...){
			Application->MessageBox("cfg file is incorect!\n\n\"background color(R,G,B)\" must be list of integers.","PVWin",MB_OK+MB_ICONWARNING);
		}
	}

	if((i=key->IndexOf("animation(off=0)"))>=0)
		AnimeTimer->Enabled=(value->Strings[i]!="0");
	if((i=key->IndexOf("anime interval"))>=0){
		try{
			AnimeTimer->Interval=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"anime interval\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			AnimeTimer->Interval=1;
		}
	}

	if((i=key->IndexOf("scene"))>=0){
		try{
			Scene=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"scene\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			Scene=0;
		}
	}
	if((i=key->IndexOf("step"))>=0){
		try{
			Step=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"step\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			Step=1;
		}
	}
	if((i=key->IndexOf("expand speed x"))>=0){
		try{
			DX=StrToFloat(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"expand speed x\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			DX=0.0;
		}
	}
	if((i=key->IndexOf("expand speed y"))>=0){
		try{
			DY=StrToFloat(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"expand speed y\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			DY=0.0;
		}
	}
	if((i=key->IndexOf("expand speed y"))>=0){
		try{
			DZ=StrToFloat(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"expand speed z\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			DZ=0.0;
		}
	}
	if ((i=key->IndexOf("expand rate x"))>=0){
		try{
			RX=StrToFloat(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"expand rate x\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			RX=1.0;
		}
	}
	if((i=key->IndexOf("expand rate y"))>=0){
		try{
			RY=StrToFloat(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"expand rate y\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			RY=1.0;
		}
	}
	if((i=key->IndexOf("expand rate z"))>=0){
		try{
			RZ=StrToFloat(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"expand rate z\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			RZ=1.0;
		}
	}

	if((i=key->IndexOf("magnification"))>=0){
		try{
			Screen=-ViewPoint*StrToFloat(value->Strings[i])*5.0;
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"magnification\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			Screen=-ViewPoint*5.0;
		}
	}
	if((i=key->IndexOf("ball mag"))>=0){
		try{
			BallMag=StrToFloat(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"ball mag\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			BallMag=1.0;
		}
	}

	if((i=key->IndexOf("alpha"))>=0){
		try{
			Alpha=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"alpha\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			Alpha=0.0;
		}
		CA=cos((float)Alpha/180*M_PI);
		SA=sin((float)Alpha/180*M_PI);
	}
	if((i=key->IndexOf("beta"))>=0){
		try{
			Beta=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"beta\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			Beta=0.0;
		}
		CB=cos((float)Beta/180*M_PI);
		SB=sin((float)Beta/180*M_PI);
	}

	if((i=key->IndexOf("shift right"))>=0){
		try{
			ShiftX=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"shift right\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			ShiftX=0;
		}
	}
	if((i=key->IndexOf("shift up"))>=0){
		try{
			ShiftY=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"shift up\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			ShiftY=0;
		}
	}

	if((i=key->IndexOf("x center"))>=0){
		try{
			CShiftX=(int)(StrToFloat(value->Strings[i])*100);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"x center\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			CShiftX=0;
		}
	}
	if((i=key->IndexOf("y center"))>=0){
		try{
			CShiftY=(int)(StrToFloat(value->Strings[i])*100);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"y center\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			CShiftY=0;
		}
	}
	if((i=key->IndexOf("z center"))>=0){
		try{
			CShiftZ=(int)(StrToFloat(value->Strings[i])*100);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"z center\" must be real number.","PVWin",MB_OK+MB_ICONWARNING);
			CShiftZ=0;
		}
	}

	if((i=key->IndexOf("fix slice(off=0)"))>=0){
		FixSliceMenu->Checked=(value->Strings[i]!="0");
		if(key->Strings[i+1]=="thickness")
			try{
				FThickness=StrToInt(value->Strings[i+1])*50;
			}
			catch(...){
				Application->MessageBox("cfg file is incorrect!\n\n\"thickness\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
				FThickness=500;
			}
	}
	if((i=key->IndexOf("fix thickness"))>=0){
		try{
			FThickness=StrToInt(value->Strings[i])*50;
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"fix thickness\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			FThickness=500;
		}
	}
	if((i=key->IndexOf("not fix slice(off=0)"))>=0){
		NotFixSliceMenu->Checked=(value->Strings[i]!="0");
		if(key->Strings[i+1]=="thickness")
			try{
				NFThickness=StrToInt(value->Strings[i+1])*50;
			}
			catch(...){
				Application->MessageBox("cfg file is incorrect!\n\n\"thickness\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
				NFThickness=500;
			}
	}
	if((i=key->IndexOf("not fix thickness"))>=0){
		try{
			NFThickness=StrToInt(value->Strings[i])*50;
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"not fix thickness\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			NFThickness=500;
		}
	}

	if((i=key->IndexOf("frame(off=0)"))>=0)
		FramedMenu->Checked=(value->Strings[i]!="0");
	if((i=key->IndexOf("perspective(off=0)"))>=0)
		PerspectiveMenu->Checked=(value->Strings[i]!="0");

	if((i=key->IndexOf("number(off=0)"))>=0)
		NumberedMenu->Checked=(value->Strings[i]!="0");

	if((i=key->IndexOf("hide mol(off=0)"))>=0)
		HideMolMenu->Checked=(value->Strings[i]!="0");
	if((i=key->IndexOf("hide mol color"))>=0){
		if(value->Strings[i]!=""&&!ReadColorList(DispColor,value->Strings[i],false))
			Application->MessageBox("cfg file is incorrect!\n\n\"hide mol color\" must be list of integers.","PVWin",MB_OK+MB_ICONWARNING);;
		for(i=0;i<16;i++)
			PopupMenu->Items->Items[i]->Checked=!DispColor[i];
	}

	if((i=key->IndexOf("hide bond(off=0)"))>=0)
		HideBondMenu->Checked=(value->Strings[i]!="0");
	if((i=key->IndexOf("hide bond color"))>=0){
		if(value->Strings[i]!=""&&!ReadColorList(DispBColor,value->Strings[i],false))
			Application->MessageBox("cfg file is incorrect!\n\n\"hide bondl color\" must be list of integers.","PVWin",MB_OK+MB_ICONWARNING);;
	}

	if((i=key->IndexOf("time(off=0)"))>=0)
		DispTimeMenu->Checked=(value->Strings[i]!="0");
	if((i=key->IndexOf("time font size"))>=0){
		try{
			Canvas->Font->Size=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"time font size\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
		}
	}
	if((i=key->IndexOf("time position x"))>=0){
		try{
			TimeX=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"time position x\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			TimeX=ClientWidth;
		}
	}
	if((i=key->IndexOf("time position y"))>=0){
		try{
			TimeY=StrToInt(value->Strings[i]);
		}
		catch(...){
			Application->MessageBox("cfg file is incorrect!\n\n\"time position y\" must be integer.","PVWin",MB_OK+MB_ICONWARNING);
			TimeY=0;
		}
	}

	if((i=key->IndexOf("thick bond(off=0)"))>=0)
		ThickBondMenu->Checked=(value->Strings[i]!="0");
}
//---------------------------------------------------------------------------
bool __fastcall TMainForm::ReadColorList(bool *disp,AnsiString list,bool warn)
{
	int i,n0,n1;
	AnsiString temp1,temp2;

	temp1=list;
	while(temp1.Pos(",")!=0){
		temp2=temp1.SubString(1,temp1.Pos(",")-1);
		temp1.Delete(1,temp1.Pos(","));
		if(temp2.Pos("-")!=0){
			try{
				n0=StrToInt((temp2.SubString(1,temp2.Pos("-")-1)));
			}
			catch(...){
				if(warn)
					Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
				return false;
			}

			temp2.Delete(1,temp2.Pos("-"));

			try{
				n1=StrToInt(temp2);
			}
			catch(...){
				if(warn)
					Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
				return false;
			}

			if(n0<0)
				n0=0;
			if(n1>15)
				n1=15;
			for(i=n0;i<=n1;i++)
				disp[i]=!disp[i];
		}
		else{
			try{
				i=StrToInt(temp2);
			}
			catch(...){
				if(warn)
					Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
				return false;
			}

			if((i>=0)&&(i<=15))
				disp[i]=!disp[i];
		}
	}
	if(temp1.Pos("-")!=0){
		try{
			n0=StrToInt((temp1.SubString(1,temp1.Pos("-")-1)));
		}
		catch(...){
			if(warn)
				Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
			return false;
		}

		temp1.Delete(1,temp1.Pos("-"));

		try{
			n1=StrToInt(temp1);
		}
		catch(...){
			if(warn)
				Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
			return false;
		}

		if(n0<0)
			n0=0;
		if(n1>15)
			n1=15;
		for(i=n0;i<=n1;i++)
			disp[i]=!disp[i];
	}
	else{
		try{
			i=StrToInt(temp1);
		}
		catch(...){
			if(warn)
				Application->MessageBox("Input list of integers \"1,3,5-7\" !","PVWin",MB_OK+MB_ICONSTOP);
			return false;
		}

		if((i>=0)&&(i<=15))
			disp[i]=!disp[i];
	}

	return true;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::Draw(bool readdata)
{
	int moltype,x0,y0,z0;
	Point WVec1,WVec2,WVec3,Pbuf,Pbuf2;

	float time;
	AnsiString temp;
	int i,ii,i0,i1,i2,im,jm,ix,iy,ix0,iy0,y,attr;

	if(MolType==0)
		moltype=NMol;
	else
		moltype=MolType;

	ScreenBitmap->Width=ClientWidth;
	ScreenBitmap->Height=ClientHeight;
	ScreenBitmap->Canvas->Brush->Style=bsSolid;
	ScreenBitmap->Canvas->Brush->Color=BGColor;
	ScreenBitmap->Canvas->Pen->Color=BGColor;
	ScreenBitmap->Canvas->Rectangle(0,0,ClientWidth,ClientHeight);
	ScreenBitmap->Canvas->Brush->Style=bsClear;

	ViewX=-ViewPoint*CB*SA;
	ViewY=ViewPoint*CB*CA;
	ViewZ=-ViewPoint*SB;

	Vlx=(int)(Vlx0*pow(RX,Scene))+(int)(DX*100*Scene);
	Vly=(int)(Vly0*pow(RY,Scene))+(int)(DY*100*Scene);
	Vlz=(int)(Vlz0*pow(RZ,Scene))+(int)(DZ*100*Scene);

	if(X0==0){
		x0=0;
		FPoint[0].x= Vlx/2;
		FPoint[1].x=-Vlx/2;
		FPoint[2].x= Vlx/2;
		FPoint[3].x=-Vlx/2;
		FPoint[4].x= Vlx/2;
		FPoint[5].x=-Vlx/2;
		FPoint[6].x= Vlx/2;
		FPoint[7].x=-Vlx/2;
	}
	else{
		x0=(int)(X0*pow(RX,Scene))+(int)(DX*Scene/2);
		FPoint[0].x=Vlx-Vlx0/2;
		FPoint[2].x=Vlx-Vlx0/2;
		FPoint[4].x=Vlx-Vlx0/2;
		FPoint[6].x=Vlx-Vlx0/2;
	}
	if(Y0==0){
		y0=0;
		FPoint[0].y= Vly/2;
		FPoint[1].y= Vly/2;
		FPoint[2].y=-Vly/2;
		FPoint[3].y=-Vly/2;
		FPoint[4].y= Vly/2;
		FPoint[5].y= Vly/2;
		FPoint[6].y=-Vly/2;
		FPoint[7].y=-Vly/2;
	}
	else{
		y0=(int)(Y0*pow(RY,Scene))+(int)(DY*Scene/2);
		FPoint[0].y=Vly-Vly0/2;
		FPoint[1].y=Vly-Vly0/2;
		FPoint[4].y=Vly-Vly0/2;
		FPoint[5].y=Vly-Vly0/2;
	}
	if(Z0==0){
		z0=0;
		FPoint[0].z= Vlz/2;
		FPoint[1].z= Vlz/2;
		FPoint[2].z= Vlz/2;
		FPoint[3].z= Vlz/2;
		FPoint[4].z=-Vlz/2;
		FPoint[5].z=-Vlz/2;
		FPoint[6].z=-Vlz/2;
		FPoint[7].z=-Vlz/2;
	}
	else{
		z0=(int)(Z0*pow(RZ,Scene))+(int)(DZ*Scene/2);
		FPoint[0].z=Vlz-Vlz0/2;
		FPoint[1].z=Vlz-Vlz0/2;
		FPoint[2].z=Vlz-Vlz0/2;
		FPoint[3].z=Vlz-Vlz0/2;
	}

	VisibleMol=0;
	VisibleBond=0;

	if(FramedMenu->Checked){
		for(i=0;i<6;i++){
			i0=Frame[i][0];
			i1=Frame[i][1];
			i2=Frame[i][2];

			WVec1.x=(FPoint[i1].x-FPoint[i0].x)/100;
			WVec1.y=(FPoint[i1].y-FPoint[i0].y)/100;
			WVec1.z=(FPoint[i1].z-FPoint[i0].z)/100;
			WVec2.x=(FPoint[i2].x-FPoint[i0].x)/100;
			WVec2.y=(FPoint[i2].y-FPoint[i0].y)/100;
			WVec2.z=(FPoint[i2].z-FPoint[i0].z)/100;

			WVec3.x=WVec1.y*WVec2.z-WVec1.z*WVec2.y;
			WVec3.y=WVec1.z*WVec2.x-WVec1.x*WVec2.z;
			WVec3.z=WVec1.x*WVec2.y-WVec1.y*WVec2.x;

			im=WVec3.x*((FPoint[i0].x-ViewX)/100)
				+WVec3.y*((FPoint[i0].y-ViewY)/100)
				+WVec3.z*((FPoint[i0].z-ViewZ)/100);
			if(im>0)
				FBack[i]=true;
			else
				FBack[i]=false;
		}
	}

	if(FramedMenu->Checked){
		ScreenBitmap->Canvas->Pen->Color=FGColor;
		for(i=0;i<6;i++){
			if(FBack[i]){
				im=Frame[i][0];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix0,iy0);
				ScreenBitmap->Canvas->MoveTo(ix0,iy0);

				im=Frame[i][1];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				ScreenBitmap->Canvas->LineTo(ix,iy);

				im=Frame[i][3];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				ScreenBitmap->Canvas->LineTo(ix,iy);

				im=Frame[i][2];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				ScreenBitmap->Canvas->LineTo(ix,iy);

				ScreenBitmap->Canvas->LineTo(ix0,iy0);
			}
		}
	}

	if(readdata){
		fseek(fp,HeaderSize+Scene*BlockSize,0);
		if(PV16){
			for(i=0;i<NMol;i++){
				fread(&Atom16,sizeof(AtomRec16),1,fp);
				Atom[i].Attr=Atom16.Attr;
				Atom[i].x=Atom16.x;
				Atom[i].y=Atom16.y;
				Atom[i].z=Atom16.z;
			}
			for(i=0;i<NBond;i++){
				fread(&Bond16,sizeof(BondRec16),1,fp);
				Bond[i].Attr=Bond16.Attr;
				Bond[i].p1=Bond16.p1;
				Bond[i].p2=Bond16.p2;
			}
		}
		else{
			fread(Atom,sizeof(AtomRec),NMol,fp);
			fread(Bond,sizeof(BondRec),NBond,fp);
		}

		for(i=0;i<NMol;i++){
			if(CShiftX==0)
				Atom[i].x=Atom[i].x-X0;
			else{
				Pbuf.x=Atom[i].x+CShiftX-x0;
				Atom[i].x=(long)(Pbuf.x-ceil((float)Pbuf.x/Vlx-0.5)*Vlx+x0-X0);
			}
			if(CShiftY==0)
				Atom[i].y=Atom[i].y-Y0;
			else{
				Pbuf.y=Atom[i].y+CShiftY-y0;
				Atom[i].y=(long)(Pbuf.y-ceil((float)Pbuf.y/Vly-0.5)*Vly+y0-Y0);
			}
			if(CShiftZ==0)
				Atom[i].z=Atom[i].z-Z0;
			else{
				Pbuf.z=Atom[i].z+CShiftZ-z0;
				Atom[i].z=(long)(Pbuf.z-ceil((float)Pbuf.z/Vlz-0.5)*Vlz+z0-Z0);
			}
		}
	}

	SortAtom();

	for(i=0;i<NMol+NBond;i++){
		im=CompList[i];
		if(im<NMol){
			if(FSliced){
				Pbuf.x=Atom[im].x;
				Pbuf.y=Atom[im].y;
				Pbuf.z=Atom[im].z;

				y=(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB);

				if((y<-FThickness)||(y>FThickness)){
					DispMol[im]=false;
					continue;
				}
			}
			attr=Atom[im].Attr;
			if((!HideMolMenu->Checked)&&(DispMol[im])&&(DispColor[attr])){
				if(!FSliced){
					Pbuf.x=Atom[im].x;
					Pbuf.y=Atom[im].y;
					Pbuf.z=Atom[im].z;

					y=(int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB);
				}

				if(!NotFixSliceMenu->Checked||((y>=-NFThickness)&&(y<=NFThickness))){
					VisibleMol++;

					ii=AtomList[im%moltype];

					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
					        y,
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					BallImageList->Draw(ScreenBitmap->Canvas,
					      ix-BallSize[ii]/2,iy-BallSize[ii]/2,ii*16+attr,true);

					if(MolType==0){
						if(NumberedMenu->Checked||Numbered[im])
							ScreenBitmap->Canvas->TextOut(ix,iy,im+1);
					}
					else if((NumberedMenu->Checked||Numbered[im/MolType])&&(im%MolType==0))
						ScreenBitmap->Canvas->TextOut(ix,iy,im/MolType+1);
				}
			}
		}
		else{
			ii=CompList[i]-NMol;
			attr=Bond[ii].Attr;
			if((!HideBondMenu->Checked)&&(attr!=0xff)&&(DispBColor[attr/16])){
				ScreenBitmap->Canvas->Pen->Color=BondColor[attr/16];

				if(ThickBondMenu->Checked)
					ScreenBitmap->Canvas->Pen->Width=-Screen/ViewPoint*(attr-attr/16*16+1)/50;

				im=Bond[ii].p1-1;
				jm=Bond[ii].p2-1;

				Pbuf.x=Atom[im].x;
				Pbuf.y=Atom[im].y;
				Pbuf.z=Atom[im].z;
				Pbuf2.x=Atom[jm].x;
				Pbuf2.y=Atom[jm].y;
				Pbuf2.z=Atom[jm].z;

				VisibleBond++;

				if((abs(Pbuf.x-Pbuf2.x)<(float)Vlx/2)
				 &&(abs(Pbuf.y-Pbuf2.y)<(float)Vly/2)
				 &&(abs(Pbuf.z-Pbuf2.z)<(float)Vlz/2)){
					Project((int)(Pbuf.x*CA+Pbuf.y*SA),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
					        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
					ScreenBitmap->Canvas->MoveTo(ix,iy);

					Project((int)(Pbuf2.x*CA+Pbuf2.y*SA),
					        (int)((-Pbuf2.x*SA+Pbuf2.y*CA)*CB-Pbuf2.z*SB),
					        (int)((-Pbuf2.x*SA+Pbuf2.y*CA)*SB+Pbuf2.z*CB),ix,iy);
					ScreenBitmap->Canvas->LineTo(ix,iy);
				}
			}
			ScreenBitmap->Canvas->Pen->Width=1;
		}
	}

	if(FramedMenu->Checked){
		ScreenBitmap->Canvas->Pen->Color=FGColor;
		for(i=0;i<6;i++){
			if(!FBack[i]){
				im=Frame[i][0];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix0,iy0);
				ScreenBitmap->Canvas->MoveTo(ix0,iy0);

				im=Frame[i][1];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				ScreenBitmap->Canvas->LineTo(ix,iy);

				im=Frame[i][3];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				ScreenBitmap->Canvas->LineTo(ix,iy);

				im=Frame[i][2];
				Pbuf.x=FPoint[im].x;
				Pbuf.y=FPoint[im].y;
				Pbuf.z=FPoint[im].z;
				Project((int)(Pbuf.x*CA+Pbuf.y*SA),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*CB-Pbuf.z*SB),
				        (int)((-Pbuf.x*SA+Pbuf.y*CA)*SB+Pbuf.z*CB),ix,iy);
				ScreenBitmap->Canvas->LineTo(ix,iy);

				ScreenBitmap->Canvas->LineTo(ix0,iy0);
			}
		}
	}

	time=Time0+DT*Scene;
	if(DT<0.01)
		temp=FloatToStrF(time,ffFixed,15,3)+"ps";
	else if(DT<0.1)
		temp=FloatToStrF(time,ffFixed,15,2)+"ps";
	else if(DT<1)
		temp=FloatToStrF(time,ffFixed,15,1)+"ps";
	else if(DT<100)
		temp=FloatToStrF(time,ffFixed,15,0)+"ps";
	else if(DT<1000)
		temp=FloatToStrF(time/1000,ffFixed,15,1)+"ns";
	else
		temp=FloatToStrF(time/1000,ffFixed,15,0)+"ns";

	if(DispTimeMenu->Checked){
		ScreenBitmap->Canvas->Font->Size=Canvas->Font->Size;
		ScreenBitmap->Canvas->TextOut(TimeX-ScreenBitmap->Canvas->TextWidth(temp),TimeY,temp);
		ScreenBitmap->Canvas->Font->Size=12;
	}

	Canvas->Draw(0,0,ScreenBitmap);

	MainForm->Caption=OpenDialog->FileName+"   "+Scene+"/"+(NScene-1)+"   "+temp;

	if(SaveAnimeMenu->Checked){
		temp=AnimeFrame;
		while(temp.Length()<4)
			temp="0"+temp;
		ScreenBitmap->SaveToFile(AnimeDir+"\\"+temp+".bmp");
		AnimeFrame++;
		MainForm->Caption=MainForm->Caption+"   "+temp+".bmp";
	}

	FSliced=false;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::Project(int x,int y,int z,int &ix,int &iy)
{
	int py;

	py=(PerspectiveMenu->Checked)? y-ViewPoint : -ViewPoint;
	ix=ClientWidth/2+(int)(x*(Screen/100)/py)+(int)(Screen/ViewPoint*ShiftX);
	iy=ClientHeight/2-(int)(z*(Screen/100)/py)-(int)(Screen/ViewPoint*ShiftY);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SortAtom(void)
{
	int i;

	for(i=0;i<NMol;i++)
		Distance[i]=((float)(Atom[i].x-ViewX))*(Atom[i].x-ViewX)
				+((float)(Atom[i].y-ViewY))*(Atom[i].y-ViewY)
				+((float)(Atom[i].z-ViewZ))*(Atom[i].z-ViewZ);

	for(i=0;i<NBond;i++){
		if(Bond[i].Attr!=0xff)
			Distance[i+NMol]=Distance[Bond[i].p1-1]/2
				+Distance[Bond[i].p2-1]/2;
		else
			Distance[i+NMol]=0;
	}

	QSort(0,NMol+NBond-1);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::QSort(int f,int l)
{
	int i,j,k;
	float d;

	i=f;
	j=l;
	d=Distance[CompList[(f+l)/2]];

	while(i<=j){
		while(Distance[CompList[i]]>d)
			i++;
		while(Distance[CompList[j]]<d)
			j--;
		if(i<=j){
			k=CompList[i];
			CompList[i]=CompList[j];
			CompList[j]=k;
			i++;
			j--;
		}
	}

	if(f<j)
		QSort(f,j);
	if(i<l)
		QSort(i,l);
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::AnimeTimerTimer(TObject *Sender)
{
	AnimeTimer->Enabled=false;
	Scene+=Step;

	if(Scene<=0){
		Scene=0;
		AnimeTimer->Enabled=false;
		Draw(true);
		return;
	}
	if(Scene>=NScene-1){
		Scene=NScene-1;
		AnimeTimer->Enabled=false;
		Draw(true);
		return;
	}

	Draw(true);
	AnimeTimer->Enabled=true;
}
//---------------------------------------------------------------------------

