#include "stdio.h"
#include "string.h"	   
#include "malloc.h"
#include "stdlib.h"
#include "math.h"
#define LBond   2.0e0
#define LB2     3.0e0
#define LB3     3.5e0

struct Header{ 
  char String[32];
  unsigned short MolType;
  unsigned short NMol; 
  unsigned short NBond;
  unsigned short NDat;
  double VLx1; double VLx2; 
  double VLy1; double VLy2;
  double VLz1; double VLz2;
  double Time0;
  double DT;
};


#pragma pack(1)
struct Atom{
	  unsigned char Attr;
      short x,y,z;
};
#pragma pack()

#pragma pack(1)
struct Bond{
  unsigned char Attr;
  unsigned short p1,p2;
};
#pragma pack()

struct Vector{
  double x,y,z;
};

FILE *fo,*fp;
struct Atom *AtomBuf;
struct Bond *BondBuf;
struct Vector VL;
struct Header h;
unsigned short MType,Numc,Numh,NData;

void FillAtomBuf(void);
void FillBondBuf(void);

main(int argc, char *argv[])
{
  char ch;
  int i,ipos,j;
  double d1x,d1y,d1z,d2,d3,*s;
  double x,y,z;

  if (argc!=3) exit(0);
  fp = fopen(argv[1],"r");
  if (ferror(fp)!=0){
    printf("file access failed for %s\n",argv[1]);
  }
  else {
    printf("file access succeeded for %s\n",argv[1]);
  }
  
  fo = fopen(argv[2],"wb");

  strncpy(h.String,"PV-01 /Shoji-Maruyama Laboratory",32);
  fscanf(fp,"%u %u %u %u %lf %lf %lf %lf %lf",
             &MType,&Numc,&Numh,&NData,&d1x,&d1y,&d1z,&d2,&d3);
  printf("Total %u data\n",NData);

  VL.x = d1x;
  VL.y = d1y;
  VL.z = d1z;

//  h.MolType = MType;
  h.MolType = 0;
  h.NMol    = Numc+Numh;
  h.NBond   = h.NMol*2;
  h.NDat    = NData;
  h.VLx1  = -d1x/2.0; h.VLy1 = -d1y/2.0; h.VLz1 = -d1z/2.0;
  h.VLx2  =  d1x/2.0; h.VLy2 =  d1y/2.0; h.VLz2 =  d1z/2.0;
  h.Time0 = d2;
  h.DT    = d3;
 
  fwrite(&h, sizeof(struct Header), 1, fo);

  s = (double *)malloc( h.NMol *sizeof(double));
  for(i=0;i<Numc;i++) s[i]=1.0;
  for(i=Numc;i<h.NMol;i++) s[i]=2.0;
  fwrite(s, sizeof(double), h.NMol, fo);
//  h.NMol    = Numc+Numh;

/*  switch(h.MolType){
    case 1 :  s[0] = 1.0; break;
    case 2 :  s[0] = 1.2; s[1] = 0.6; break;
    case 3 :  s[0] = 1.2; s[1] = 0.6; s[2] = 0.6; break;
  }
  fwrite(s, sizeof(double), h.MolType, fo);
*/

  AtomBuf = (struct Atom *)malloc( h.NMol *sizeof(struct Atom));
  BondBuf = (struct Bond *)malloc( h.NBond*sizeof(struct Bond));
  
  for(i=1;i<=h.NDat;i++){
    if((i % 100)==0)  printf("step %d\n",i);
    if (feof(fp)!=0) {
      printf("This calculation has not finished yet!\n");
      break;
    }
 
    FillAtomBuf();
    FillBondBuf();

    fwrite(AtomBuf, sizeof(struct Atom), h.NMol, fo);
    fwrite(BondBuf, sizeof(struct Bond), h.NBond, fo);

  }
  free((void *)AtomBuf);
  free((void *)BondBuf);
  free((void *)s);

  fclose(fp);
  fclose(fo);

  return(0);
}


int round(double a)
{
  int rf,rc,ir;
  
  rf = (int)floor(a);
  rc = rf+1;
  if((a-(double)rf)>((double)rc-a)) ir = rc;
  else ir = rf;
  return(ir);
}


void FillAtomBuf(void)
{
  unsigned short i,j;
  double x,y,z;
  
  for(i=0;i<h.NMol;i++){
    fscanf(fp,"%lf %lf %lf",&x,&y,&z);

    x = x - VL.x*(double)round(x/VL.x);
    y = y - VL.y*(double)round(y/VL.y);
    z = z - VL.z*(double)round(z/VL.z);

    AtomBuf[i].Attr = (unsigned char)0;
    AtomBuf[i].x = (short)round(x*1.0e2);
    AtomBuf[i].y = (short)round(y*1.0e2);
    AtomBuf[i].z = (short)round(z*1.0e2);
  }
}


void FillBondBuf(void){
  int i,j,a;
  unsigned short Count;
  double x,y,z,r;
  unsigned char *AtomPot;

  AtomPot = malloc( h.NMol * sizeof(unsigned char));
  for(i=0;i<Numc;i++) AtomPot[i] = 0;

  Count = 0;
  for(i=0;i<Numc-1;i++){
    for(j=i+1;j<Numc;j++){
      x = ((double)AtomBuf[i].x - (double)AtomBuf[j].x)/1.0e2;
      x = x - VL.x*(double)round(x/VL.x);
      if (x>=LBond) continue;

      y = ((double)AtomBuf[i].y - (double)AtomBuf[j].y)/1.0e2;
      y = y - VL.y*(double)round(y/VL.y);
      if (y>=LBond) continue;

      z = ((double)AtomBuf[i].z - (double)AtomBuf[j].z)/1.0e2;
      z = z - VL.z*(double)round(z/VL.z);
      if (z>=LBond) continue;

      r=sqrt(x*x + y*y + z*z);
      if(r>=LBond) continue;

      ++AtomPot[i]; ++AtomPot[j];
      if(Count<h.NBond){
        a = 16 - round(r/LBond*10);
        BondBuf[Count].Attr = (unsigned char)(0x70+a);
        BondBuf[Count].p1 = (unsigned short)(i+1);
        BondBuf[Count].p2 = (unsigned short)(j+1);
        ++Count;
      }
    }
  }


  for(i=0;i<Numc;i++){
    for(j=Numc;j<h.NMol;j++){
      x = ((double)AtomBuf[i].x - (double)AtomBuf[j].x)/1.0e2;
      x = x - VL.x*(double)round(x/VL.x);
      if (x>=LB2) continue;

      y = ((double)AtomBuf[i].y - (double)AtomBuf[j].y)/1.0e2;
      y = y - VL.y*(double)round(y/VL.y);
      if (y>=LB2) continue;

      z = ((double)AtomBuf[i].z - (double)AtomBuf[j].z)/1.0e2;
      z = z - VL.z*(double)round(z/VL.z);
      if (z>=LB2) continue;

      r=sqrt(x*x + y*y + z*z);
      if(r>=LB2) continue;

//      ++AtomPot[i]; ++AtomPot[j];
      if(Count<h.NBond){
        BondBuf[Count].Attr = (unsigned char)0x10;
        BondBuf[Count].p1 = (unsigned short)(i+1);
        BondBuf[Count].p2 = (unsigned short)(j+1);
        ++Count;
      }
    }
  }


  for(i=Numc;i<h.NMol-1;i++){
    for(j=i+1;j<h.NMol;j++){
      x = ((double)AtomBuf[i].x - (double)AtomBuf[j].x)/1.0e2;
      x = x - VL.x*(double)round(x/VL.x);
      if (x>=LB3) continue;

      y = ((double)AtomBuf[i].y - (double)AtomBuf[j].y)/1.0e2;
      y = y - VL.y*(double)round(y/VL.y);
      if (y>=LB3) continue;

      z = ((double)AtomBuf[i].z - (double)AtomBuf[j].z)/1.0e2;
      z = z - VL.z*(double)round(z/VL.z);
      if (z>=LB3) continue;

      r=sqrt(x*x + y*y + z*z);
      if(r>=LB3) continue;

//      ++AtomPot[i]; ++AtomPot[j];
      if(Count<h.NBond){
        BondBuf[Count].Attr = (unsigned char)(0x10);
        BondBuf[Count].p1 = (unsigned short)(i+1);
        BondBuf[Count].p2 = (unsigned short)(j+1);
        ++Count;
      }
    }
  }


  if(Count<=h.NBond){
    for(i=Count;i<h.NBond;i++) BondBuf[i].Attr=0xff;
    for(i=0;i<Numc;i++){
      switch(AtomPot[i]){
        case 0  : AtomBuf[i].Attr = 15; break;
        case 1  : AtomBuf[i].Attr = 14; break;
        case 2  : AtomBuf[i].Attr = 10; break;
        case 3  : AtomBuf[i].Attr = 2;  break;
        default : AtomBuf[i].Attr = 1;
      }
    }
  }
  else{
    printf("Bond number exceeded the limit. (count=%d\n",Count);
    exit(1);
  }

  free((void *)AtomPot);
}
