#include <math.h>
void settings(int *ch_n, int *ch_m, double *acc, int *ntube);
int cdev(int , int );
double unitlength(int n, int m, double acc);

void settings(int *ch_n, int *ch_m, double *acc, int *ntube)
{
        FILE *fpset;
        if( (fpset = fopen("setting.dat", "r")) == NULL){
                printf("setting.dat is not available\n Manually specify n,m,bondlength, ntube");
                return;
        }
        fscanf(fpset, "%ld %ld %lf %ld", ch_n, ch_m, acc, ntube);
		fclose(fpset);
}

int chiral(int n, int m, double acc)
{
	double dia, theta, T;
	int T1, T2;
	double Ch;
	double a;
	double pi;
	int i,j;
	int d, dR;
	int metal;
	int nmax;
	int N;
	double K1x, K1y, K2x, K2y;
	double b1x, b1y, b2x, b2y;

	a = sqrt(3)*acc;
	pi = 4*atan(1.0);

	b1x = 2*pi/a/sqrt(3);
	b1y = 2*pi/a;
	b2x = 2*pi/a/sqrt(3);
	b2y = -2*pi/a;
	Ch = a*sqrt(n*n+n*m+m*m);
	dia = Ch/pi;
	theta = atan((sqrt(3)*m/(2.0*n+m)));
	theta=theta*180.0/pi;
	d = cdev(n,m);
	if( (n-m) % 3 == 0) metal = 1;
	else metal = 0;
	if( (n-m) % (3*d) != 0) dR = d;
	else dR = 3*d;
	T1 = (2*m+n)/dR;
	T2 = -(2*n+m)/dR;
	T = sqrt(3)*Ch/dR;
	N = 2*(m*m + n*n + n*m)/dR;
	K1x = ( (2*n+m)*b1x + (2*m+n)*b2x )/N/dR;
	K1y = ( (2*n+m)*b1y + (2*m+n)*b2y )/N/dR;
	K2x = ( m*b1x - n*b2x )/N;
	K2y = ( m*b1y - n*b2y )/N;
	return N;
}

double unitlength(int n, int m, double acc)
{
	double dia, theta, T;
	int T1, T2;
	double Ch;
	double a;
	double pi;
	int i,j;
	int d, dR;
	int metal;
	int nmax;
	int N;
	double K1x, K1y, K2x, K2y;
	double b1x, b1y, b2x, b2y;

	a = sqrt(3)*acc;
	pi = 4*atan(1.0);

	b1x = 2*pi/a/sqrt(3);
	b1y = 2*pi/a;
	b2x = 2*pi/a/sqrt(3);
	b2y = -2*pi/a;
	Ch = a*sqrt(n*n+n*m+m*m);
	dia = Ch/pi;
	theta = atan((sqrt(3)*m/(2.0*n+m)));
	theta=theta*180.0/pi;
	d = cdev(n,m);
	if( (n-m) % 3 == 0) metal = 1;
	else metal = 0;
	if( (n-m) % (3*d) != 0) dR = d;
	else dR = 3*d;
	T1 = (2*m+n)/dR;
	T2 = -(2*n+m)/dR;
	T = sqrt(3)*Ch/dR;
	N = 2*(m*m + n*n + n*m)/dR;
	K1x = ( (2*n+m)*b1x + (2*m+n)*b2x )/N/dR;
	K1y = ( (2*n+m)*b1y + (2*m+n)*b2y )/N/dR;
	K2x = ( m*b1x - n*b2x )/N;
	K2y = ( m*b1y - n*b2y )/N;
	return T;
}
// calculate the highest common devisor
int cdev(int ii, int jj)
{
	int i, j;
	int iw, ir;
	i=abs(ii);
	j=abs(jj);
	if(j > i) {  //switch to i>j
		iw=j;
		j=i;
		i=iw;
	}
	if(j == 0){
		return i;
	}
	while(1){
		ir = i % j;  //mod (i,j)
		if(ir == 0){
			return j;
		}
		else{
			i = j;
			j = ir;
		}
	}
}
