//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "tube.h"
#include <stdio.h>
#include <stdlib.h>
#include "chirality.c"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
#include <math.h>
void __fastcall TForm1::NmakeitClick(TObject *Sender)
{
double a = 1.4595;
double pi = 3.1415926535897932384626433832795;
FILE *fp;
double hx[6], hy[6], hz[6];
int ih, i,j, k, np;
double offx, offy, offz;
double nx = 10,ny = 10;
double theta = 0;
double R, phi, len;
int nstep = 20;
int istep = 0;
// showing
int irad = 1;
int ixc = Image1->Width/2;
int iyc = Image1->Height/2;
int imag = 6;
double vx, vy, vx1, vy1,vx2, vy2, vlen;
double tempx, tempy;
int ch_n, ch_m;
double tubelen, BoundaryLength;



fp = fopen("swnt_pos.dat", "w");

// getting parameters
   a = Ea->Text.ToDouble();
   nx = Enx->Text.ToInt();
   ny = Eny->Text.ToInt();
   nstep = Ensteps->Text.ToInt();
   imag = Emag->Text.ToInt();
   ch_n = En->Text.ToInt();
   ch_m = Em->Text.ToInt();
   tubelen = Etubelen->Text.ToDouble();
   BoundaryLength= EBoundaryLength->Text.ToDouble();

if(nx*ny*4 > MaxMol) {
   ShowMessage("Too Many Molecules");
   return;
}

// calculations


//definition of a hexagon
hx[0] = a;  hy[0] = 0.0; hz[0] = 0.0;
for (i = 1; i<6; i++){
    hx[i] = hx[i-1]*cos(pi/3) - hy[i-1]*sin(pi/3);
    hy[i] = hx[i-1]*sin(pi/3) + hy[i-1]*cos(pi/3);
    hz[i] = 0.0;
}

// replicas in x direction for nx
i = -1;
for(k = 0; k<nx; k++){
      offx = 3*a*k; offy = 0.0; offz = 0.0;
      for(ih = 0; ih<4; ih++){
             i++;
            px[i] = hx[ih]+offx;
            py[i] = hy[ih]+offy;
            pz[i] = hz[ih]+offz;
      }
}
np = i+1;

// centering x
for(i = 0; i<np; i++) px[i] = px[i] - (nx-1.0)/2.0*3*a;


// replicas in y direction
j=-1;
for(k = 0; k<ny; k++){
      offx = 0.0; offy = sqrt(3.0)*a*k; offz = 0.0;
      for(i = 0; i<np; i++){
            j++;
            px[j] = px[i]+offx;
            py[j] = py[i]+offy;
            pz[j] = pz[i]+offz;
      }
}
np = j+1;

// centering y

//for(i = 0; i<np; i++) py[i] = py[i] - (ny-1.0)/2.0*sqrt(3.0)*a;


for(i = 0; i<np; i++) py[i] = py[i] - (ny-0.5)/2.0*sqrt(3.0)*a;


//Show

   Image1->Canvas->Brush->Color=clWhite;
   Image1->Canvas->Rectangle(0,0,Image1->Width,Image1->Height);
   Image1->Canvas->Pen->Color = clBlue;
   Image1->Canvas->MoveTo(0, iyc);
   Image1->Canvas->LineTo(Image1->Width, iyc);
   Image1->Canvas->MoveTo(ixc,0);
   Image1->Canvas->LineTo(ixc,Image1->Height);
   Image1->Canvas->Pen->Color = clBlack;

for(i = 0; i<np; i++){
   Image1->Canvas->Ellipse((px[i]*imag+ixc)-irad, (iyc-py[i]*imag)-irad,
       (px[i]*imag+ixc)+irad, (iyc-py[i]*imag)+irad);
}


// Rotate for (m,ch_m) vector
// sin = vy/vlen, cos=vx/vlen

vx = (ch_n+ch_m)*3.0/2.0*a;
vy = (ch_n-ch_m)*sqrt(3.0)/2.0*a;
vlen = sqrt(vx*vx+vy*vy);

vx1 = (ch_n)*3.0/2.0*a;
vy1 = (ch_n)*sqrt(3.0)/2.0*a;

// showing the vectors
   Image1->Canvas->Pen->Color = clRed;
   Image1->Canvas->MoveTo(ixc,iyc);
   Image1->Canvas->LineTo(vx1*imag+ixc,(iyc-vy1*imag));
   Image1->Canvas->LineTo(vx*imag+ixc,(iyc-vy*imag));
   Image1->Canvas->Pen->Color = clBlack;

ShowMessage("Initial Configuration is ready");


// Rotation for -

for (i=0; i<np; i++){
   tempx = px[i];
   tempy = py[i];
    px[i] = tempx*vx/vlen + tempy*vy/vlen;
    py[i] = -tempx*vy/vlen + tempy*vx/vlen;
}

   Image1->Canvas->Brush->Color=clWhite;
   Image1->Canvas->Rectangle(0,0,Image1->Width,Image1->Height);
   Image1->Canvas->Pen->Color = clBlue;
   Image1->Canvas->MoveTo(0, iyc);
   Image1->Canvas->LineTo(Image1->Width, iyc);
   Image1->Canvas->MoveTo(ixc,0);
   Image1->Canvas->LineTo(ixc,Image1->Height);
   Image1->Canvas->Pen->Color = clBlack;
for(i = 0; i<np; i++){
   Image1->Canvas->Ellipse((px[i]*imag+ixc)-irad, (iyc-py[i]*imag)-irad,
       (px[i]*imag+ixc)+irad, (iyc-py[i]*imag)+irad);
}

   tempx = vx1;
   tempy = vy1;
   vx1 = tempx*vx/vlen + tempy*vy/vlen;
   vy1 = -tempx*vy/vlen + tempy*vx/vlen;
   tempx = vx;
   tempy = vy;
   vx2 = tempx*vx/vlen + tempy*vy/vlen;
   vy2 = -tempx*vy/vlen + tempy*vx/vlen;
// showing the vectors
   Image1->Canvas->Pen->Color = clRed;
   Image1->Canvas->MoveTo(ixc,iyc);
   Image1->Canvas->LineTo(vx1*imag+ixc,(iyc-vy1*imag));
   Image1->Canvas->LineTo(vx2*imag+ixc,(iyc-vy2*imag));
   Image1->Canvas->Pen->Color = clBlack;

ShowMessage("Rotation is done");

// trimming

   j = 0;
   for( i=0; i<np; i++){
       if( (px[i] <= vlen/2.0*1.00001) && (px[i] > -vlen/2.0*0.99999)
                && (py[i] <= tubelen/2.0) && (py[i] > -tubelen/2.0)){
            px[j] = px[i];
            py[j] = py[i];
            pz[j] = pz[i];
            j++;
       }
   }
   np = j;

   Image1->Canvas->Brush->Color=clWhite;
   Image1->Canvas->Rectangle(0,0,Image1->Width,Image1->Height);
   Image1->Canvas->Pen->Color = clBlue;
   Image1->Canvas->MoveTo(0, iyc);
   Image1->Canvas->LineTo(Image1->Width, iyc);
   Image1->Canvas->MoveTo(ixc,0);
   Image1->Canvas->LineTo(ixc,Image1->Height);
   Image1->Canvas->Pen->Color = clBlack;
for(i = 0; i<np; i++){
   Image1->Canvas->Ellipse((px[i]*imag+ixc)-irad, (iyc-py[i]*imag)-irad,
       (px[i]*imag+ixc)+irad, (iyc-py[i]*imag)+irad);
}


// output pv header
     fprintf(fp, "1\n");
     fprintf(fp, "%d\n", np);
     fprintf(fp, "0\n");
if(CheckBox->Checked)
     fprintf(fp, "%d\n", 1);
else fprintf(fp, "%d\n", nstep+1);

     fprintf(fp, "60.0 %lf 60.0\n", BoundaryLength);
     fprintf(fp, "0.0\n");
     fprintf(fp, "1.0\n");

// output

if(CheckBox->Checked){
          theta = 2*pi;
          len = vlen;
          R = len/theta;
          for (i = 0; i<np; i++){
              phi = px[i]/R;
              qx[i] = R*sin(phi);
              qy[i] = py[i];
              qz[i] = -R*cos(phi);
          }
          // output
          for (i = 0; i<np; i++){
              fprintf(fp, "%lf\t%lf\t%lf\n", qx[i], qy[i], qz[i]);
          }
}
else{
     for (i = 0; i<np; i++){
         fprintf(fp, "%lf\t%lf\t%lf\n", px[i], py[i], pz[i]);
         }

////// Curing steps
       for(istep = 0; istep<nstep; istep++){
          theta = (istep+1)*2*pi/nstep;

          len = vlen;
          R = len/theta;

          for (i = 0; i<np; i++){
              phi = px[i]/R;
              qx[i] = R*sin(phi);
              qy[i] = py[i];
              qz[i] = R*(1.0-cos(phi));
          }

          // output
          for (i = 0; i<np; i++){
              fprintf(fp, "%lf\t%lf\t%lf\n", qx[i], qy[i], qz[i]);
          }
       }
}

fclose(fp);

//ShowMessage("done: "+(AnsiString)np);
StatusBar1->SimpleText="Done: "+ (AnsiString)np+"   swnt_pos.dat is made";

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
    AnsiString syscommand;
    syscommand = "hpvc.exe swnt_pos.dat swnt_pos.pv";
    system(syscommand.c_str());
    StatusBar1->SimpleText="swnt_pos.pv is made";

}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button2Click(TObject *Sender)
{
    AnsiString syscommand;

    syscommand = "PVWIN.exe swnt_pos.pv";
    system(syscommand.c_str());

}

//---------------------------------------------------------------------------
void __fastcall TForm1::BUnitCellClick(TObject *Sender)
{
double T;
double a;
int n, m;

   a = Ea->Text.ToDouble();
   n = En->Text.ToInt();
   m = Em->Text.ToInt();
   T = unitlength(n, m, a);
   Etubelen->Text=(AnsiString)T;
   EBoundaryLength->Text=(AnsiString)T;

}
//---------------------------------------------------------------------------

