#include <stdio.h>
#include <stdlib.h>

int attachdat (char fnout[], char fn1[], char fn2[])
{
    const int FDEBUG = 0;
    FILE *fp1, *fp2, *fo;
    int imol, idat, nmol;
    int mtype1, nmol1, ndat1;
    int mtype2, nmol2, ndat2;
    double vlx1, vly1, vlz1;
    double vlx2, vly2, vlz2;
    double qx, qy, qz;
    double ts1, dt1, ts2, dt2;
    
    //******************************
    // Open files
    //******************************
    fo = fopen(fnout,"w");
    fp1 = fopen(fn1,"r");
    fp2 = fopen(fn2,"r");
    if (fp1==NULL || ferror(fp1)){
        printf("Error: file access failed for %s\n",fn1);
        return(EXIT_FAILURE);
    }
    if (fp2==NULL || ferror(fp2)){
        printf("Error: file access failed for %s\n",fn2);
        return(EXIT_FAILURE);
    }
    if (FDEBUG) {
        printf (" -- input file1: %s\n",fn1);
        printf (" -- input file2: %s\n",fn2);
        printf (" -- output file: %s\n",fnout);
    }
    
    //******************************
    // header
    //******************************
    fscanf(fp1,"%d %d %d",&mtype1,&nmol1,&ndat1);
    fscanf(fp1,"%lf %lf %lf",&vlx1,&vly1,&vlz1);
    fscanf(fp1,"%lf %lf",&ts1,&dt1);
    fscanf(fp2,"%d %d %d",&mtype2,&nmol2,&ndat2);
    fscanf(fp2,"%lf %lf %lf",&vlx2,&vly2,&vlz2);
    fscanf(fp2,"%lf %lf",&ts2,&dt2);
    
    if (ndat1!=ndat2) {
        printf("Error: number of scenes are different");
        printf(" (%d and %d).\n",ndat1,ndat2);
        exit(EXIT_FAILURE);
    }
    nmol = nmol1 + nmol2;
    vlx1 = (vlx1>vlx2 ? vlx1 : vlx2);
    vly1 = (vly1>vly2 ? vly1 : vly2);
    vlz1 = (vlz1>vlz2 ? vlz1 : vlz2);
    
    fprintf(fo,"%d %d %d\n",mtype1,nmol,ndat1);
    fprintf(fo,"%lf %lf %lf\n",vlx1,vly1,vlz1);
    fprintf(fo,"%lf %lf\n",ts1,dt1);
    
    //******************************
    // body
    //******************************
    for (idat=0; idat<ndat1; idat++) {
        for (imol=0; imol<nmol1; imol++) {
            fscanf (fp1,"%lf %lf %lf"  ,&qx,&qy,&qz);
            fprintf(fo, "%15.7lf %15.7lf %15.7lf\n",qx,qy,qz);
            
        }
        for (imol=0; imol<nmol2; imol++) {
            fscanf (fp2,"%lf %lf %lf"  ,&qx,&qy,&qz);
            fprintf(fo, "%15.7lf %15.7lf %15.7lf\n",qx,qy,qz);
        }
    }
    //******************************
    // End function
    //******************************
    fclose(fp1);
    fclose(fp2);
    fclose(fo);
    return(EXIT_SUCCESS);
}

int main(int argc, char *argv[])
{
    int i;
    char filetmp[200] = "datadd_temp.tmp";
    if (argc<3) {
        printf ("Error: two or three arguments are required.\n");
        return(EXIT_FAILURE);
    }
    for (i=2; i<(int)argc; i++) {
        rename(argv[1],filetmp);
        attachdat(argv[1],filetmp,argv[i]);
        remove(filetmp);
        remove(argv[i]);
    }
    return(EXIT_SUCCESS);
}
